/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzdc;
import java.util.Collections;
import java.util.List;

@VisibleForTesting
public final class zzba
extends zzau {
    private final zzbc zzww;
    private zzcl zzwx;
    private final zzbz zzwy;
    private final zzdc zzwz;

    protected zzba(zzaw zzaw2) {
        super(zzaw2);
        this.zzwz = new zzdc(zzaw2.zzbx());
        this.zzww = new zzbc(this);
        this.zzwy = new zzbb(this, zzaw2);
    }

    @Override
    protected final void zzag() {
    }

    public final boolean isConnected() {
        zzk.zzaf();
        this.zzcl();
        return this.zzwx != null;
    }

    public final boolean zzb(zzck zzck2) {
        Preconditions.checkNotNull((Object)zzck2);
        zzk.zzaf();
        this.zzcl();
        zzcl zzcl2 = this.zzwx;
        if (zzcl2 == null) {
            return false;
        }
        String string = zzck2.zzet() ? zzbx.zzed() : zzbx.zzee();
        List<zzbr> list = Collections.emptyList();
        try {
            zzcl2.zza(zzck2.zzcw(), zzck2.zzer(), string, list);
            this.zzcy();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzcx() {
        zzk.zzaf();
        this.zzcl();
        zzcl zzcl2 = this.zzwx;
        if (zzcl2 == null) {
            return false;
        }
        try {
            zzcl2.zzbr();
            this.zzcy();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzq("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzcy() {
        this.zzwz.start();
        this.zzwy.zzh(zzcf.zzaaf.get());
    }

    public final boolean connect() {
        zzk.zzaf();
        this.zzcl();
        if (this.zzwx != null) {
            return true;
        }
        zzcl zzcl2 = this.zzww.zzda();
        if (zzcl2 != null) {
            this.zzwx = zzcl2;
            this.zzcy();
            return true;
        }
        return false;
    }

    private final void zza(zzcl zzcl2) {
        zzk.zzaf();
        this.zzwx = zzcl2;
        this.zzcy();
        this.zzcc().onServiceConnected();
    }

    public final void disconnect() {
        zzk.zzaf();
        this.zzcl();
        try {
            ConnectionTracker.getInstance().unbindService(this.getContext(), (ServiceConnection)this.zzww);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzwx != null) {
            this.zzwx = null;
            this.zzcc().zzbu();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzk.zzaf();
        if (this.zzwx != null) {
            this.zzwx = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzcc().zzbu();
        }
    }

    private final void zzcz() {
        zzk.zzaf();
        if (!this.isConnected()) {
            return;
        }
        this.zzq("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzbc zza(zzba zzba2) {
        return zzba2.zzww;
    }

    static /* synthetic */ void zza(zzba zzba2, zzcl zzcl2) {
        zzba2.zza(zzcl2);
    }

    static /* synthetic */ void zza(zzba zzba2, ComponentName componentName) {
        zzba2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzba zzba2) {
        zzba2.zzcz();
    }
}

