/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzcm;

@VisibleForTesting
public final class zzbc
implements ServiceConnection {
    private volatile zzcl zzxb;
    private volatile boolean zzxc;
    final /* synthetic */ zzba zzxa;

    protected zzbc(zzba zzba2) {
        this.zzxa = zzba2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzcl zzda() {
        zzk.zzaf();
        Intent intent = new Intent("com.google.android.gms.analytics.service.START");
        intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
        Context context = this.zzxa.getContext();
        intent.putExtra("app_package_name", context.getPackageName());
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzbc zzbc2 = this;
        synchronized (zzbc2) {
            this.zzxb = null;
            this.zzxc = true;
            boolean bl = connectionTracker.bindService(context, intent, (ServiceConnection)zzba.zza(this.zzxa), 129);
            this.zzxa.zza("Bind to service requested", bl);
            if (!bl) {
                this.zzxc = false;
                return null;
            }
            try {
                long l = zzcf.zzaag.get();
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                this.zzxa.zzt("Wait for service connect was interrupted");
            }
            this.zzxc = false;
            zzcl zzcl2 = this.zzxb;
            this.zzxb = null;
            if (zzcl2 == null) {
                this.zzxa.zzu("Successfully bound to service but never got onServiceConnected callback");
            }
            return zzcl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceConnected");
        zzbc zzbc2 = this;
        synchronized (zzbc2) {
            try {
                String string;
                if (iBinder == null) {
                    this.zzxa.zzu("Service connected with null binder");
                    return;
                }
                zzcl zzcl2 = null;
                try {
                    string = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(string)) {
                        IInterface iInterface;
                        IBinder iBinder2 = iBinder;
                        zzcl2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.analytics.internal.IAnalyticsService")) instanceof zzcl ? (zzcl)iInterface : new zzcm(iBinder2));
                        this.zzxa.zzq("Bound to IAnalyticsService interface");
                    } else {
                        this.zzxa.zze("Got binder with a wrong descriptor", string);
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzxa.zzu("Service connect failed to get IAnalyticsService");
                }
                if (zzcl2 == null) {
                    try {
                        ConnectionTracker.getInstance().unbindService(this.zzxa.getContext(), (ServiceConnection)zzba.zza(this.zzxa));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!this.zzxc) {
                    this.zzxa.zzt("onServiceConnected received after the timeout limit");
                    string = zzcl2;
                    this.zzxa.zzca().zza(new zzbd(this, (zzcl)((Object)string)));
                } else {
                    this.zzxb = zzcl2;
                }
            }
            finally {
                this.notifyAll();
            }
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"AnalyticsServiceConnection.onServiceDisconnected");
        this.zzxa.zzca().zza(new zzbe(this, componentName));
    }
}

