/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzdx;

public final class zzcc
extends zzau {
    private boolean zzyr;
    private boolean zzys;
    private final AlarmManager zzyt = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzyu;

    protected zzcc(zzaw zzaw2) {
        super(zzaw2);
    }

    @Override
    protected final void zzag() {
        try {
            Context context;
            ActivityInfo activityInfo;
            this.cancel();
            if (zzbx.zzea() > 0L && (activityInfo = (context = this.getContext()).getPackageManager().getReceiverInfo(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver"), 0)) != null && activityInfo.enabled) {
                this.zzq("Receiver registered for local dispatch.");
                this.zzyr = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzem() {
        return this.zzyr;
    }

    public final boolean zzej() {
        return this.zzys;
    }

    public final void zzen() {
        this.zzcl();
        Preconditions.checkState((boolean)this.zzyr, (Object)"Receiver not registered");
        long l = zzbx.zzea();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzbx().elapsedRealtime() + l;
            this.zzys = true;
            zzcf.zzaam.get().booleanValue();
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzq("Scheduling upload with JobScheduler");
                long l3 = l;
                zzcc zzcc2 = this;
                Context context = zzcc2.getContext();
                ComponentName componentName = new ComponentName(context, "com.google.android.gms.analytics.AnalyticsJobService");
                int n = zzcc2.getJobId();
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
                zzcc2.zza("Scheduling job. JobID", n);
                zzdx.zza((Context)context, (JobInfo)jobInfo, (String)"com.google.android.gms", (String)"DispatchAlarm");
                return;
            }
            this.zzq("Scheduling upload with AlarmManager");
            this.zzyt.setInexactRepeating(2, l2, l, this.zzeo());
        }
    }

    private final PendingIntent zzeo() {
        Context context = this.getContext();
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH").setComponent(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzys = false;
        this.zzyt.cancel(this.zzeo());
        if (Build.VERSION.SDK_INT >= 24) {
            zzcc zzcc2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzcc2.getContext().getSystemService("jobscheduler");
            int n = zzcc2.getJobId();
            zzcc2.zza("Cancelling job. JobID", n);
            jobScheduler.cancel(n);
        }
    }

    private final int getJobId() {
        if (this.zzyu == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyu = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzyu;
    }
}

