/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzcp;
import com.google.android.gms.internal.measurement.zzcw;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.stats.WakeLock;

public final class zzcx<T extends Context> {
    private final Handler handler;
    private final T zzaby;
    private static Boolean zzabz;

    public zzcx(T t) {
        Preconditions.checkNotNull(t);
        this.zzaby = t;
        this.handler = new zzea();
    }

    public static boolean zze(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzabz != null) {
            return zzabz;
        }
        boolean bl = zzdg.zzc(context, "com.google.android.gms.analytics.AnalyticsService");
        zzabz = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onCreate() {
        zzaw.zzc(this.zzaby).zzby().zzq("Local AnalyticsService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onDestroy() {
        zzaw.zzc(this.zzaby).zzby().zzq("Local AnalyticsService is shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final int onStartCommand(Intent intent, int n, int n2) {
        try {
            Object object = zzcw.lock;
            synchronized (object) {
                WakeLock wakeLock = zzcw.zzabx;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {}
        zzcp zzcp2 = zzaw.zzc(this.zzaby).zzby();
        if (intent == null) {
            zzcp2.zzt("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcp2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcy(this, n2, zzcp2));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzaw.zzc(this.zzaby).zzcc().zza(new zzda(this, runnable));
    }

    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcp zzcp2 = zzaw.zzc(this.zzaby).zzby();
        String string = jobParameters.getExtras().getString("action");
        zzcp2.zza("Local AnalyticsJobService called. action", (Object)string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcz(this, zzcp2, jobParameters));
        }
        return true;
    }

    final /* synthetic */ void zza(zzcp zzcp2, JobParameters jobParameters) {
        zzcp2.zzq("AnalyticsJobService processed last dispatch request");
        ((zzdb)this.zzaby).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzcp zzcp2) {
        if (((zzdb)this.zzaby).callServiceStopSelfResult(n)) {
            zzcp2.zzq("Local AnalyticsService processed last dispatch request");
        }
    }

    static /* synthetic */ Handler zza(zzcx zzcx2) {
        return zzcx2.handler;
    }
}

