/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzaa;
import com.google.android.gms.internal.gtm.zzab;
import com.google.android.gms.internal.gtm.zzac;
import com.google.android.gms.internal.gtm.zzam;
import com.google.android.gms.internal.gtm.zzao;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzas;
import com.google.android.gms.internal.gtm.zzcd;
import com.google.android.gms.internal.gtm.zzcz;
import com.google.android.gms.internal.gtm.zzq;
import com.google.android.gms.internal.gtm.zzr;
import com.google.android.gms.internal.gtm.zzs;
import com.google.android.gms.internal.gtm.zzt;
import com.google.android.gms.internal.gtm.zzu;
import com.google.android.gms.internal.gtm.zzv;
import com.google.android.gms.internal.gtm.zzw;
import com.google.android.gms.internal.gtm.zzx;
import com.google.android.gms.internal.gtm.zzy;
import com.google.android.gms.internal.gtm.zzz;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzam
implements zzo {
    private static DecimalFormat zzrf;
    private final zzap zzrb;
    private final String zzrg;
    private final Uri zzrh;

    public zzb(zzap zzap2, String string) {
        this(zzap2, string, true, false);
    }

    private zzb(zzap zzap2, String string, boolean bl, boolean bl2) {
        super(zzap2);
        Preconditions.checkNotEmpty((String)string);
        this.zzrb = zzap2;
        this.zzrg = string;
        this.zzrh = zzb.zzb(this.zzrg);
    }

    static Uri zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzae() {
        return this.zzrh;
    }

    @Override
    public final void zzb(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        Preconditions.checkArgument((boolean)zzg2.zzan(), (Object)"Can't deliver not submitted measurement");
        Preconditions.checkNotMainThread((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzai();
        zzz zzz2 = zzg3.zzb(zzz.class);
        if (TextUtils.isEmpty((CharSequence)zzz2.zzbs())) {
            this.zzco().zza(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzz2.zzbt())) {
            this.zzco().zza(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzrb.zzde().getAppOptOut()) {
            return;
        }
        double d = zzz2.zzbz();
        if (zzcz.zza(d, zzz2.zzbt())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzao.zzwe);
        map.put("tid", this.zzrg);
        if (this.zzrb.zzde().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzcz.zzb(hashMap, "uid", zzz2.zzbu());
        zzq zzq2 = zzg2.zza(zzq.class);
        if (zzq2 != null) {
            zzcz.zzb(hashMap, "an", zzq2.zzaz());
            zzcz.zzb(hashMap, "aid", zzq2.zzbb());
            zzcz.zzb(hashMap, "av", zzq2.zzba());
            zzcz.zzb(hashMap, "aiid", zzq2.zzbc());
        }
        zzas zzas2 = new zzas(0L, zzz2.zzbt(), this.zzrg, !TextUtils.isEmpty((CharSequence)zzz2.zzbv()), 0L, hashMap);
        long l = this.zzcs().zza(zzas2);
        map.put("_s", String.valueOf(l));
        zzcd zzcd2 = new zzcd(this.zzco(), map, zzg2.zzal(), true);
        this.zzcs().zza(zzcd2);
    }

    @VisibleForTesting
    private static Map<String, String> zzc(zzg zzg2) {
        zzq zzq2;
        zzt zzt2;
        Object object;
        Object object2;
        Object object3;
        zzs zzs2;
        zzac zzac2;
        zzab zzab2;
        zzy zzy2;
        zzr zzr2;
        zzx zzx2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzu zzu2 = zzg2.zza(zzu.class);
        if (zzu2 != null) {
            object5 = zzu2.zzbm().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zza((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzx2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzx2));
            }
        }
        if ((object5 = zzg2.zza(zzz.class)) != null) {
            zzb.zza(hashMap, "t", ((zzz)object5).zzbs());
            zzb.zza(hashMap, "cid", ((zzz)object5).zzbt());
            zzb.zza(hashMap, "uid", ((zzz)object5).zzbu());
            zzb.zza(hashMap, "sc", ((zzz)object5).zzbx());
            zzb.zza(hashMap, "sf", ((zzz)object5).zzbz());
            zzb.zza(hashMap, "ni", ((zzz)object5).zzby());
            zzb.zza(hashMap, "adid", ((zzz)object5).zzbv());
            zzb.zza(hashMap, "ate", ((zzz)object5).zzbw());
        }
        if ((object4 = zzg2.zza(zzaa.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzaa)object4).zzca());
            zzb.zza(hashMap, "a", ((zzaa)object4).zzcb());
            zzb.zza(hashMap, "dr", ((zzaa)object4).zzcc());
        }
        if ((zzx2 = zzg2.zza(zzx.class)) != null) {
            zzb.zza(hashMap, "ec", zzx2.zzbr());
            zzb.zza(hashMap, "ea", zzx2.getAction());
            zzb.zza(hashMap, "el", zzx2.getLabel());
            zzb.zza(hashMap, "ev", zzx2.getValue());
        }
        if ((zzr2 = zzg2.zza(zzr.class)) != null) {
            zzb.zza(hashMap, "cn", zzr2.getName());
            zzb.zza(hashMap, "cs", zzr2.getSource());
            zzb.zza(hashMap, "cm", zzr2.zzbd());
            zzb.zza(hashMap, "ck", zzr2.zzbe());
            zzb.zza(hashMap, "cc", zzr2.zzbf());
            zzb.zza(hashMap, "ci", zzr2.getId());
            zzb.zza(hashMap, "anid", zzr2.zzbg());
            zzb.zza(hashMap, "gclid", zzr2.zzbh());
            zzb.zza(hashMap, "dclid", zzr2.zzbi());
            zzb.zza(hashMap, "aclid", zzr2.zzbj());
        }
        if ((zzy2 = zzg2.zza(zzy.class)) != null) {
            zzb.zza(hashMap, "exd", zzy2.zzuq);
            zzb.zza(hashMap, "exf", zzy2.zzur);
        }
        if ((zzab2 = zzg2.zza(zzab.class)) != null) {
            zzb.zza(hashMap, "sn", zzab2.zzvh);
            zzb.zza(hashMap, "sa", zzab2.zzvi);
            zzb.zza(hashMap, "st", zzab2.zzvj);
        }
        if ((zzac2 = zzg2.zza(zzac.class)) != null) {
            zzb.zza(hashMap, "utv", zzac2.zzvk);
            zzb.zza(hashMap, "utt", zzac2.zzvl);
            zzb.zza(hashMap, "utc", zzac2.mCategory);
            zzb.zza(hashMap, "utl", zzac2.zzvm);
        }
        if ((zzs2 = zzg2.zza(zzs.class)) != null) {
            object3 = zzs2.zzbk().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zze(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzt2 = zzg2.zza(zzt.class)) != null) {
            object2 = zzt2.zzbl().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zzg((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zza((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzw.class)) != null) {
            object2 = ((zzw)object3).zzbn();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzw)object3).zzbq()) {
                hashMap.putAll(promotion.zzn(zzd.zzk(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzw)object3).zzbo()) {
                hashMap.putAll(product.zzn(zzd.zzi(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzw)object3).zzbp().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzn(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzl(n2));
                    hashMap.putAll(product.zzn(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzv.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzv)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzv)object2).zzuk);
            zzb.zza(hashMap, "sr", ((zzv)object2).zzul, ((zzv)object2).zzum);
            zzb.zza(hashMap, "vp", ((zzv)object2).zzun, ((zzv)object2).zzuo);
        }
        if ((zzq2 = zzg2.zza(zzq.class)) != null) {
            zzb.zza(hashMap, "an", zzq2.zzaz());
            zzb.zza(hashMap, "aid", zzq2.zzbb());
            zzb.zza(hashMap, "aiid", zzq2.zzbc());
            zzb.zza(hashMap, "av", zzq2.zzba());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    private static String zza(double d) {
        if (zzrf == null) {
            zzrf = new DecimalFormat("0.######");
        }
        return zzrf.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zza(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

