/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzcz;
import com.google.android.gms.internal.gtm.zzq;
import com.google.android.gms.internal.gtm.zzv;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@VisibleForTesting
@SuppressLint(value={"StaticFieldLeak"})
public final class zzk {
    private static volatile zzk zzsq;
    private final Context zzrm;
    private final List<zzn> zzsr;
    private final zze zzss;
    private final zza zzst;
    private volatile zzq zzsu;
    private Thread.UncaughtExceptionHandler zzsv;

    @VisibleForTesting
    private zzk(Context context) {
        Context context2 = context.getApplicationContext();
        Preconditions.checkNotNull((Object)context2);
        this.zzrm = context2;
        this.zzst = new zza();
        this.zzsr = new CopyOnWriteArrayList<zzn>();
        this.zzss = new zze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzk zzb(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzsq != null) return zzsq;
        Class<zzk> clazz = zzk.class;
        synchronized (zzk.class) {
            if (zzsq != null) return zzsq;
            zzsq = new zzk(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzsq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzq zzat() {
        if (this.zzsu == null) {
            zzk zzk2 = this;
            synchronized (zzk2) {
                if (this.zzsu == null) {
                    zzq zzq2 = new zzq();
                    PackageManager packageManager = this.zzrm.getPackageManager();
                    String string = this.zzrm.getPackageName();
                    zzq2.setAppId(string);
                    zzq2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.zzrm.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzq2.setAppName(string2);
                    zzq2.setAppVersion(string3);
                    this.zzsu = zzq2;
                }
            }
        }
        return this.zzsu;
    }

    public final zzv zzau() {
        int n;
        DisplayMetrics displayMetrics = this.zzrm.getResources().getDisplayMetrics();
        zzv zzv2 = new zzv();
        zzv2.setLanguage(zzcz.zza(Locale.getDefault()));
        zzv2.zzul = n = displayMetrics.widthPixels;
        zzv2.zzum = n = displayMetrics.heightPixels;
        return zzv2;
    }

    final void zze(zzg zzg2) {
        if (zzg2.zzaq()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzg2.zzan()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzg zzg3 = zzg2.zzai();
        zzg3.zzao();
        this.zzst.execute(new zzl(this, zzg3));
    }

    public final Context getContext() {
        return this.zzrm;
    }

    public static void zzav() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzsv = uncaughtExceptionHandler;
    }

    public final <V> Future<V> zza(Callable<V> callable) {
        Preconditions.checkNotNull(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzst.submit(callable);
    }

    public final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        this.zzst.submit(runnable);
    }

    private static void zzb(zzg zzg2) {
        Preconditions.checkNotMainThread((String)"deliver should be called from worker thread");
        Preconditions.checkArgument((boolean)zzg2.zzan(), (Object)"Measurement must be submitted");
        List<zzo> list = zzg2.zzak();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zzae();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zzb(zzg2);
        }
    }

    static /* synthetic */ List zza(zzk zzk2) {
        return zzk2.zzsr;
    }

    static /* synthetic */ void zza(zzk zzk2, zzg zzg2) {
        zzk.zzb(zzg2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzk zzk2) {
        return zzk2.zzsv;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzsz = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzsz.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzl zzl2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzm(this, runnable, t);
        }
    }
}

