/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzan;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzcv;
import com.google.android.gms.internal.gtm.zzcz;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

@VisibleForTesting
public final class zzad
extends zzan {
    private static boolean zzvo;
    private AdvertisingIdClient.Info zzvp;
    private final zzcv zzvq;
    private String zzvr;
    private boolean zzvs = false;
    private final Object zzvt = new Object();

    zzad(zzap zzap2) {
        super(zzap2);
        this.zzvq = new zzcv(zzap2.zzcn());
    }

    @Override
    protected final void zzaw() {
    }

    public final boolean zzbw() {
        this.zzdb();
        AdvertisingIdClient.Info info = this.zzce();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzcd() {
        this.zzdb();
        AdvertisingIdClient.Info info = this.zzce();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzce() {
        if (this.zzvq.zzj(1000L)) {
            this.zzvq.start();
            AdvertisingIdClient.Info info = this.zzcf();
            if (this.zza(this.zzvp, info)) {
                this.zzvp = info;
            } else {
                this.zzu("Failed to reset client id on adid change. Not using adid");
                this.zzvp = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzvp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzcw().zzeh();
        Object object = this.zzvt;
        synchronized (object) {
            String string3;
            if (!this.zzvs) {
                this.zzvr = this.zzcg();
                this.zzvs = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzvr)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzp(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzvr = zzad.zzo(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzad.zzo(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzvr)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzvr)) {
                this.zzq("Resetting the client id because Advertising Id changed.");
                string2 = this.zzcw().zzei();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzp(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzcf() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzt("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Exception exception) {
                if (zzvo) break block3;
                zzvo = true;
                this.zzd("Error getting advertiser id", exception);
            }
        }
        return info;
    }

    private static String zzo(String string) {
        MessageDigest messageDigest = zzcz.zzai("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzp(String string) {
        try {
            String string2 = zzad.zzo(string);
            this.zzq("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzvr = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzcg() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzt("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzq("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

