/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzan;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzby;
import com.google.android.gms.internal.gtm.zzdb;

public final class zzbv
extends zzan {
    private boolean zzyv;
    private boolean zzyw;
    private final AlarmManager zzyx = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzyy;

    protected zzbv(zzap zzap2) {
        super(zzap2);
    }

    @Override
    protected final void zzaw() {
        try {
            Context context;
            ActivityInfo activityInfo;
            this.cancel();
            if (zzbq.zzeq() > 0L && (activityInfo = (context = this.getContext()).getPackageManager().getReceiverInfo(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver"), 0)) != null && activityInfo.enabled) {
                this.zzq("Receiver registered for local dispatch.");
                this.zzyv = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzfc() {
        return this.zzyv;
    }

    public final boolean zzez() {
        return this.zzyw;
    }

    public final void zzfd() {
        this.zzdb();
        Preconditions.checkState((boolean)this.zzyv, (Object)"Receiver not registered");
        long l = zzbq.zzeq();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzcn().elapsedRealtime() + l;
            this.zzyw = true;
            zzby.zzaaq.get().booleanValue();
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzq("Scheduling upload with JobScheduler");
                long l3 = l;
                zzbv zzbv2 = this;
                Context context = zzbv2.getContext();
                ComponentName componentName = new ComponentName(context, "com.google.android.gms.analytics.AnalyticsJobService");
                int n = zzbv2.getJobId();
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
                zzbv2.zza("Scheduling job. JobID", n);
                zzdb.zza(context, jobInfo, "com.google.android.gms", "DispatchAlarm");
                return;
            }
            this.zzq("Scheduling upload with AlarmManager");
            this.zzyx.setInexactRepeating(2, l2, l, this.zzfe());
        }
    }

    private final PendingIntent zzfe() {
        Context context = this.getContext();
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH").setComponent(new ComponentName(context, "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzyw = false;
        this.zzyx.cancel(this.zzfe());
        if (Build.VERSION.SDK_INT >= 24) {
            zzbv zzbv2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzbv2.getContext().getSystemService("jobscheduler");
            int n = zzbv2.getJobId();
            zzbv2.zza("Cancelling job. JobID", n);
            jobScheduler.cancel(n);
        }
    }

    private final int getJobId() {
        if (this.zzyy == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyy = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzyy;
    }
}

