/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.gtm.zzap;
import com.google.android.gms.internal.gtm.zzci;
import com.google.android.gms.internal.gtm.zzcp;
import com.google.android.gms.internal.gtm.zzcr;
import com.google.android.gms.internal.gtm.zzcs;
import com.google.android.gms.internal.gtm.zzct;
import com.google.android.gms.internal.gtm.zzcu;
import com.google.android.gms.internal.gtm.zzcz;
import com.google.android.gms.internal.gtm.zzdj;
import com.google.android.gms.stats.WakeLock;

public final class zzcq<T extends Context> {
    private final Handler handler;
    private final T zzacc;
    private static Boolean zzacd;

    public zzcq(T t) {
        Preconditions.checkNotNull(t);
        this.zzacc = t;
        this.handler = new zzdj();
    }

    public static boolean zze(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (zzacd != null) {
            return zzacd;
        }
        boolean bl = zzcz.zzc(context, "com.google.android.gms.analytics.AnalyticsService");
        zzacd = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onCreate() {
        zzap.zzc(this.zzacc).zzco().zzq("Local AnalyticsService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onDestroy() {
        zzap.zzc(this.zzacc).zzco().zzq("Local AnalyticsService is shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final int onStartCommand(Intent intent, int n, int n2) {
        try {
            Object object = zzcp.lock;
            synchronized (object) {
                WakeLock wakeLock = zzcp.zzacb;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {}
        zzci zzci2 = zzap.zzc(this.zzacc).zzco();
        if (intent == null) {
            zzci2.zzt("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzci2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcr(this, n2, zzci2));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzap.zzc(this.zzacc).zzcs().zza(new zzct(this, runnable));
    }

    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzci zzci2 = zzap.zzc(this.zzacc).zzco();
        String string = jobParameters.getExtras().getString("action");
        zzci2.zza("Local AnalyticsJobService called. action", (Object)string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zzb(new zzcs(this, zzci2, jobParameters));
        }
        return true;
    }

    final /* synthetic */ void zza(zzci zzci2, JobParameters jobParameters) {
        zzci2.zzq("AnalyticsJobService processed last dispatch request");
        ((zzcu)this.zzacc).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzci zzci2) {
        if (((zzcu)this.zzacc).callServiceStopSelfResult(n)) {
            zzci2.zzq("Local AnalyticsService processed last dispatch request");
        }
    }

    static /* synthetic */ Handler zza(zzcq zzcq2) {
        return zzcq2.handler;
    }
}

