/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpo;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrj;
import com.google.android.gms.internal.gtm.zzsv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzpq
extends zzpo<Boolean>
implements zzrj<Boolean>,
zzsv,
RandomAccess {
    private static final zzpq zzavv = new zzpq(new boolean[0], 0);
    private boolean[] zzavw;
    private int size;

    zzpq() {
        this(new boolean[10], 0);
    }

    private zzpq(boolean[] blArray, int n) {
        this.zzavw = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzmz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzavw, n2, this.zzavw, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzpq)) {
            return super.equals(object);
        }
        zzpq zzpq2 = (zzpq)object;
        if (this.size != zzpq2.size) {
            return false;
        }
        boolean[] blArray = zzpq2.zzavw;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzavw[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzre.zzk(this.zzavw[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzmz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
        if (this.size < this.zzavw.length) {
            System.arraycopy(this.zzavw, n, this.zzavw, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzavw, 0, blArray, 0, n);
            System.arraycopy(this.zzavw, n, blArray, n + 1, this.size - n);
            this.zzavw = blArray;
        }
        this.zzavw[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzmz();
        zzre.checkNotNull(collection);
        if (!(collection instanceof zzpq)) {
            return super.addAll(collection);
        }
        zzpq zzpq2 = (zzpq)collection;
        if (zzpq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzpq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzpq2.size;
        if (n > this.zzavw.length) {
            this.zzavw = Arrays.copyOf(this.zzavw, n);
        }
        System.arraycopy(zzpq2.zzavw, 0, this.zzavw, this.size, zzpq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzmz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzavw[i])) continue;
            System.arraycopy(this.zzavw, i + 1, this.zzavw, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzah(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
    }

    private final String zzai(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzpq zzpq2 = this;
        zzpq2.zzmz();
        zzpq2.zzah(n);
        boolean bl3 = zzpq2.zzavw[n];
        zzpq2.zzavw[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzpq zzpq2 = this;
        zzpq2.zzmz();
        zzpq2.zzah(n);
        boolean bl = zzpq2.zzavw[n];
        if (n < zzpq2.size - 1) {
            System.arraycopy(zzpq2.zzavw, n + 1, zzpq2.zzavw, n, zzpq2.size - n - 1);
        }
        --zzpq2.size;
        ++zzpq2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzrj zzaj(int n) {
        int n2 = n;
        zzpq zzpq2 = this;
        if (n2 < zzpq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzpq(Arrays.copyOf(zzpq2.zzavw, n2), zzpq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzpq zzpq2 = this;
        zzpq2.zzah(n);
        return zzpq2.zzavw[n];
    }

    static {
        zzavv.zzmi();
    }
}

