/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import com.google.android.gms.internal.gtm.zzpo;
import com.google.android.gms.internal.gtm.zzre;
import com.google.android.gms.internal.gtm.zzrj;
import com.google.android.gms.internal.gtm.zzsv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzqz
extends zzpo<Float>
implements zzrj<Float>,
zzsv,
RandomAccess {
    private static final zzqz zzbag = new zzqz(new float[0], 0);
    private float[] zzbah;
    private int size;

    zzqz() {
        this(new float[10], 0);
    }

    private zzqz(float[] fArray, int n) {
        this.zzbah = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzmz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbah, n2, this.zzbah, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzqz)) {
            return super.equals(object);
        }
        zzqz zzqz2 = (zzqz)object;
        if (this.size != zzqz2.size) {
            return false;
        }
        float[] fArray = zzqz2.zzbah;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzbah[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzbah[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzmz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
        if (this.size < this.zzbah.length) {
            System.arraycopy(this.zzbah, n, this.zzbah, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbah, 0, fArray, 0, n);
            System.arraycopy(this.zzbah, n, fArray, n + 1, this.size - n);
            this.zzbah = fArray;
        }
        this.zzbah[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzmz();
        zzre.checkNotNull(collection);
        if (!(collection instanceof zzqz)) {
            return super.addAll(collection);
        }
        zzqz zzqz2 = (zzqz)collection;
        if (zzqz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzqz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzqz2.size;
        if (n > this.zzbah.length) {
            this.zzbah = Arrays.copyOf(this.zzbah, n);
        }
        System.arraycopy(zzqz2.zzbah, 0, this.zzbah, this.size, zzqz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzmz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzbah[i]))) continue;
            System.arraycopy(this.zzbah, i + 1, this.zzbah, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzah(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzai(n));
        }
    }

    private final String zzai(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzqz zzqz2 = this;
        zzqz2.zzmz();
        zzqz2.zzah(n);
        float f3 = zzqz2.zzbah[n];
        zzqz2.zzbah[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzqz zzqz2 = this;
        zzqz2.zzmz();
        zzqz2.zzah(n);
        float f = zzqz2.zzbah[n];
        if (n < zzqz2.size - 1) {
            System.arraycopy(zzqz2.zzbah, n + 1, zzqz2.zzbah, n, zzqz2.size - n - 1);
        }
        --zzqz2.size;
        ++zzqz2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzrj zzaj(int n) {
        int n2 = n;
        zzqz zzqz2 = this;
        if (n2 < zzqz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzqz(Arrays.copyOf(zzqz2.zzbah, n2), zzqz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzqz zzqz2 = this;
        zzqz2.zzah(n);
        return Float.valueOf(zzqz2.zzbah[n]);
    }

    static {
        zzbag.zzmi();
    }
}

