/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzax;
import com.google.android.gms.internal.gtm.zzay;
import com.google.android.gms.internal.gtm.zzaz;
import com.google.android.gms.internal.gtm.zzba;
import com.google.android.gms.internal.gtm.zzbb;
import com.google.android.gms.internal.gtm.zzbc;
import com.google.android.gms.internal.gtm.zzbd;
import com.google.android.gms.internal.gtm.zzbe;
import com.google.android.gms.internal.gtm.zzbf;
import com.google.android.gms.internal.gtm.zzbg;
import com.google.android.gms.internal.gtm.zzbh;
import com.google.android.gms.internal.gtm.zzbi;
import com.google.android.gms.internal.gtm.zzbj;
import com.google.android.gms.internal.gtm.zzbt;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzbx;
import com.google.android.gms.internal.gtm.zzbz;
import com.google.android.gms.internal.gtm.zzez;
import com.google.android.gms.internal.gtm.zzfu;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzbt
implements zzt {
    private static DecimalFormat zza;
    private final zzbx zzb;
    private final String zzc;
    private final Uri zzd;

    static Uri zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzb() {
        return this.zzd;
    }

    static String zzc(double d) {
        if (zza == null) {
            DecimalFormat decimalFormat;
            zza = decimalFormat = new DecimalFormat("0.######");
        }
        return zza.format(d);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    public static Map zzd(zzh object) {
        zzbc zzbc2;
        Object object2;
        Map.Entry entry2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object object3 = (zzbb)((zzh)object).zzc(zzbb.class);
        if (object3 != null) {
            entry2 = ((zzbb)object3).zzd().entrySet().iterator();
            while (entry2.hasNext()) {
                object2 = entry2.next();
                object3 = object2.getValue();
                if (object3 == null) {
                    object3 = null;
                } else if (object3 instanceof String) {
                    if (TextUtils.isEmpty((CharSequence)(object3 = (String)object3))) {
                        object3 = null;
                    }
                } else {
                    object3 = object3 instanceof Double ? ((Double)(object3 = (Double)object3) != 0.0 ? com.google.android.gms.analytics.zzb.zzc((Double)object3) : null) : (object3 instanceof Boolean ? (object3 != Boolean.FALSE ? "1" : null) : object3.toString());
                }
                if (object3 == null) continue;
                hashMap.put((String)object2.getKey(), object3);
            }
        }
        if ((object3 = (zzbg)((zzh)object).zzc(zzbg.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "t", ((zzbg)object3).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cid", ((zzbg)object3).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "uid", ((zzbg)object3).zzg());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sc", null);
            com.google.android.gms.analytics.zzb.zzg(hashMap, "ni", ((zzbg)object3).zzo());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "adid", ((zzbg)object3).zzd());
            com.google.android.gms.analytics.zzb.zzg(hashMap, "ate", ((zzbg)object3).zzn());
        }
        if ((object3 = (zzbh)((zzh)object).zzc(zzbh.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cd", null);
            double d = ((zzbh)object3).zzd();
            if (d != 0.0) {
                hashMap.put("a", com.google.android.gms.analytics.zzb.zzc(d));
            }
            com.google.android.gms.analytics.zzb.zzf(hashMap, "dr", null);
        }
        if ((zzbe)((zzh)object).zzc(zzbe.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ec", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ea", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "el", null);
        }
        if ((object3 = (zzay)((zzh)object).zzc(zzay.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cn", ((zzay)object3).zzl());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cs", ((zzay)object3).zzm());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cm", ((zzay)object3).zzk());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ck", ((zzay)object3).zzj());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cc", ((zzay)object3).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ci", ((zzay)object3).zzi());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "anid", ((zzay)object3).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "gclid", ((zzay)object3).zzh());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "dclid", ((zzay)object3).zzg());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aclid", ((zzay)object3).zzd());
        }
        if ((zzbf)((zzh)object).zzc(zzbf.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "exd", null);
        }
        if ((zzbi)((zzh)object).zzc(zzbi.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sn", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sa", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "st", null);
        }
        if ((zzbj)((zzh)object).zzc(zzbj.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utv", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utc", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utl", null);
        }
        if ((object3 = (zzaz)((zzh)object).zzc(zzaz.class)) != null) {
            object3 = ((zzaz)object3).zzd().entrySet().iterator();
            while (object3.hasNext()) {
                entry2 = (Map.Entry)object3.next();
                object2 = com.google.android.gms.analytics.zzd.zzb((Integer)entry2.getKey());
                if (TextUtils.isEmpty(object2)) continue;
                hashMap.put(object2, (String)entry2.getValue());
            }
        }
        if ((object3 = (zzba)((zzh)object).zzc(zzba.class)) != null) {
            for (Map.Entry entry2 : ((zzba)object3).zzd().entrySet()) {
                object2 = com.google.android.gms.analytics.zzd.zze((Integer)entry2.getKey());
                if (TextUtils.isEmpty((CharSequence)object2)) continue;
                hashMap.put(object2, com.google.android.gms.analytics.zzb.zzc((Double)entry2.getValue()));
            }
        }
        if ((entry2 = (zzbd)((zzh)object).zzc(zzbd.class)) != null) {
            object2 = ((zzbd)((Object)entry2)).zze().iterator();
            int n = 1;
            while (object2.hasNext()) {
                hashMap.putAll(((Promotion)object2.next()).zza(com.google.android.gms.analytics.zzd.zzm(n)));
                ++n;
            }
            object2 = ((zzbd)((Object)entry2)).zzd().iterator();
            n = 1;
            while (object2.hasNext()) {
                hashMap.putAll(((Product)object2.next()).zza(com.google.android.gms.analytics.zzd.zzk(n)));
                ++n;
            }
            object2 = ((zzbd)((Object)entry2)).zzf().entrySet().iterator();
            n = 1;
            while (object2.hasNext()) {
                Map.Entry entry3 = (Map.Entry)object2.next();
                entry2 = entry3.getValue();
                entry2 = (List)((Object)entry2);
                String string = com.google.android.gms.analytics.zzd.zzh(n);
                Iterator iterator = entry2.iterator();
                int n2 = 1;
                while (iterator.hasNext()) {
                    hashMap.putAll(((Product)iterator.next()).zza(string.concat(com.google.android.gms.analytics.zzd.zzi(n2))));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry3.getKey()))) {
                    hashMap.put(string.concat("nm"), (String)entry3.getKey());
                }
                ++n;
            }
        }
        if ((zzbc2 = (zzbc)((zzh)object).zzc(zzbc.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ul", zzbc2.zzd());
            int n = zzbc2.zza;
            int n3 = zzbc2.zzb;
            if (n > 0 && n3 > 0) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append("x");
                ((StringBuilder)object2).append(n3);
                hashMap.put("sr", ((StringBuilder)object2).toString());
            }
        }
        if ((object = (zzax)((zzh)object).zzc(zzax.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "an", ((zzax)object).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aid", ((zzax)object).zzd());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aiid", ((zzax)object).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "av", ((zzax)object).zzg());
        }
        return hashMap;
    }

    public zzb(zzbx zzbx2, String string) {
        super(zzbx2);
        Preconditions.checkNotEmpty((String)string);
        this.zzb = zzbx2;
        this.zzc = string;
        this.zzd = com.google.android.gms.analytics.zzb.zza(this.zzc);
    }

    private static void zzf(Map map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
            return;
        }
    }

    private static void zzg(Map map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
            return;
        }
    }

    @Override
    public final void zze(zzh object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkArgument((boolean)((zzh)object).zzm(), (Object)"Can't deliver not submitted measurement");
        Preconditions.checkNotMainThread((String)"deliver should be called on worker thread");
        Iterator<Map.Entry<String, String>> iterator = new Iterator<Map.Entry<String, String>>((zzh)object);
        zzbg object22 = (zzbg)((zzh)((Object)iterator)).zzb(zzbg.class);
        if (TextUtils.isEmpty((CharSequence)object22.zzf())) {
            this.zzz().zzc(com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator)), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object22.zze())) {
            this.zzz().zzc(com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator)), "Ignoring measurement without client id");
            return;
        }
        if (!this.zzb.zzc().getAppOptOut()) {
            if (zzfu.zzj(0.0, object22.zze())) {
                this.zzF("Sampling enabled. Hit sampled out. sampling rate", 0.0);
                return;
            }
            iterator = com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator));
            iterator.put("v", "1");
            iterator.put("_v", zzbv.zzb);
            iterator.put("tid", this.zzc);
            if (this.zzb.zzc().isDryRunEnabled()) {
                object = new StringBuilder();
                for (Map.Entry entry : iterator.entrySet()) {
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append((String)entry.getKey());
                    ((StringBuilder)object).append("=");
                    ((StringBuilder)object).append((String)entry.getValue());
                }
                this.zzM("Dry run is enabled. GoogleAnalytics would have sent", ((StringBuilder)object).toString());
                return;
            }
            HashMap hashMap = new HashMap();
            zzfu.zzg(hashMap, "uid", object22.zzg());
            Object object2 = (zzax)((zzh)object).zzc(zzax.class);
            if (object2 != null) {
                zzfu.zzg(hashMap, "an", ((zzax)object2).zzf());
                zzfu.zzg(hashMap, "aid", ((zzax)object2).zzd());
                zzfu.zzg(hashMap, "av", ((zzax)object2).zzg());
                zzfu.zzg(hashMap, "aiid", ((zzax)object2).zze());
            }
            object2 = new zzbz(0L, object22.zze(), this.zzc, TextUtils.isEmpty((CharSequence)object22.zzd()) ^ true, 0L, hashMap);
            iterator.put("_s", String.valueOf(this.zzs().zza((zzbz)object2)));
            zzez zzez2 = new zzez(this.zzz(), (Map)((Object)iterator), ((zzh)object).zza(), true);
            this.zzs().zzh(zzez2);
            return;
        }
    }
}

