/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.gtm.zzfc;
import java.util.ArrayList;

@VisibleForTesting
public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private final Thread.UncaughtExceptionHandler zza;
    private final Tracker zzb;
    private final Context zzc;
    @Nullable
    private ExceptionParser zzd;
    @Nullable
    private GoogleAnalytics zze;

    @Nullable
    public ExceptionParser getExceptionParser() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ExceptionReporter(@NonNull Tracker tracker, @Nullable Thread.UncaughtExceptionHandler originalHandler, @NonNull Context context) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (var1_1 == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (var3_3 == null) {
            throw new NullPointerException("context cannot be null");
        }
        ((ExceptionReporter)((Object)this_)).zza = var2_2;
        ((ExceptionReporter)((Object)this_)).zzb = var1_1;
        ((ExceptionReporter)((Object)this_)).zzd = new StandardExceptionParser((Context)var3_3, new ArrayList<String>());
        ((ExceptionReporter)((Object)this_)).zzc = var3_3.getApplicationContext();
        String this_ = var2_2 == null ? "null" : var2_2.getClass().getName();
        zzfc.zzd("ExceptionReporter created, original handler is ".concat(String.valueOf(this_)));
    }

    /*
     * WARNING - void declaration
     */
    public void setExceptionParser(@Nullable ExceptionParser exceptionParser) {
        void var1_1;
        this.zzd = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
        void var2_2;
        String string;
        void var1_1;
        if (this.zzd != null) {
            string = var1_1 != null ? var1_1.getName() : null;
            string = this.zzd.getDescription(string, (Throwable)var2_2);
        } else {
            string = "UncaughtException";
        }
        zzfc.zzd("Reporting uncaught exception: ".concat(String.valueOf(string)));
        HitBuilders.ExceptionBuilder exceptionBuilder = new HitBuilders.ExceptionBuilder();
        exceptionBuilder.setDescription(string);
        exceptionBuilder.setFatal(true);
        this.zzb.send(exceptionBuilder.build());
        if (this.zze == null) {
            this.zze = GoogleAnalytics.getInstance(this.zzc);
        }
        GoogleAnalytics googleAnalytics = this.zze;
        googleAnalytics.dispatchLocalHits();
        googleAnalytics.zzb().zzf().zzn();
        if (this.zza != null) {
            zzfc.zzd("Passing exception to the original handler");
            this.zza.uncaughtException((Thread)var1_1, (Throwable)var2_2);
            return;
        }
    }

    @Nullable
    final Thread.UncaughtExceptionHandler zza() {
        return this.zza;
    }
}

