/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.internal.gtm.zzfc;
import com.google.android.gms.internal.gtm.zzfu;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@VisibleForTesting
public class HitBuilders {

    @VisibleForTesting
    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setCategory(@NonNull String category) {
            void var1_1;
            this.set("&iv", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            this.set("&cu", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setName(@NonNull String name) {
            void var1_1;
            this.set("&in", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setPrice(double price) {
            void var1_1;
            this.set("&ip", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setQuantity(long quantity) {
            void var1_1;
            this.set("&iq", Long.toString((long)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setSku(@NonNull String sku) {
            void var1_1;
            this.set("&ic", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ItemBuilder setTransactionId(@NonNull String transactionid) {
            void var1_1;
            this.set("&ti", (String)var1_1);
            return this;
        }

        public ItemBuilder() {
            this.set("&t", "item");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setAffiliation(@NonNull String affiliation) {
            void var1_1;
            this.set("&ta", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            this.set("&cu", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setRevenue(double revenue) {
            void var1_1;
            this.set("&tr", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setShipping(double shipping) {
            void var1_1;
            this.set("&ts", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setTax(double tax) {
            void var1_1;
            this.set("&tt", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TransactionBuilder setTransactionId(@NonNull String transactionid) {
            void var1_1;
            this.set("&ti", (String)var1_1);
            return this;
        }

        public TransactionBuilder() {
            this.set("&t", "transaction");
        }
    }

    @VisibleForTesting
    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public ExceptionBuilder setDescription(@NonNull String description) {
            void var1_1;
            this.set("&exd", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public ExceptionBuilder setFatal(boolean fatal) {
            void var1_1;
            this.set("&exf", zzfu.zzc((boolean)var1_1));
            return this;
        }

        public ExceptionBuilder() {
            this.set("&t", "exception");
        }
    }

    @VisibleForTesting
    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public TimingBuilder setCategory(@NonNull String category) {
            void var1_1;
            this.set("&utc", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TimingBuilder setLabel(@NonNull String label) {
            void var1_1;
            this.set("&utl", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TimingBuilder setValue(long value) {
            void var1_1;
            this.set("&utt", Long.toString((long)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public TimingBuilder setVariable(@NonNull String variable) {
            void var1_1;
            this.set("&utv", (String)var1_1);
            return this;
        }

        public TimingBuilder() {
            this.set("&t", "timing");
        }

        /*
         * WARNING - void declaration
         */
        public TimingBuilder(@NonNull String category, @NonNull String variable, long value) {
            this();
            void var1_1;
            void var3_3;
            void var2_2;
            this.setVariable((String)var2_2);
            this.setValue((long)var3_3);
            this.setCategory((String)var1_1);
        }
    }

    @VisibleForTesting
    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public SocialBuilder setAction(@NonNull String action) {
            void var1_1;
            this.set("&sa", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public SocialBuilder setNetwork(@NonNull String network) {
            void var1_1;
            this.set("&sn", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public SocialBuilder setTarget(@NonNull String target) {
            void var1_1;
            this.set("&st", (String)var1_1);
            return this;
        }

        public SocialBuilder() {
            this.set("&t", "social");
        }
    }

    @VisibleForTesting
    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public EventBuilder setAction(@NonNull String action) {
            void var1_1;
            this.set("&ea", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public EventBuilder setCategory(@NonNull String category) {
            void var1_1;
            this.set("&ec", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public EventBuilder setLabel(@NonNull String label) {
            void var1_1;
            this.set("&el", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public EventBuilder setValue(long value) {
            void var1_1;
            this.set("&ev", Long.toString((long)var1_1));
            return this;
        }

        public EventBuilder() {
            this.set("&t", "event");
        }

        /*
         * WARNING - void declaration
         */
        public EventBuilder(@NonNull String category, @NonNull String action) {
            this();
            void var2_2;
            void var1_1;
            this.setCategory((String)var1_1);
            this.setAction((String)var2_2);
        }
    }

    @VisibleForTesting
    protected static class HitBuilder<T extends HitBuilder> {
        private final Map zze = new HashMap();
        ProductAction zza;
        final Map zzb = new HashMap();
        final List zzc = new ArrayList();
        final List zzd = new ArrayList();

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T addImpression(@Nullable Product product, @Nullable String impressionList) {
            void var1_1;
            String string;
            if (product == null) {
                zzfc.zze("product should be non-null");
                return (T)this;
            }
            if (string == null) {
                string = "";
            }
            if (!this.zzb.containsKey(string)) {
                this.zzb.put(string, new ArrayList());
            }
            ((List)this.zzb.get(string)).add(var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T addProduct(@Nullable Product product) {
            void var1_1;
            if (product == null) {
                zzfc.zze("product should be non-null");
                return (T)this;
            }
            this.zzd.add(var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T addPromotion(@Nullable Promotion promotion) {
            void var1_1;
            if (promotion == null) {
                zzfc.zze("promotion should be non-null");
                return (T)this;
            }
            this.zzc.add(var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public final T set(@Nullable String paramName, @Nullable String paramValue) {
            if (paramName != null) {
                void var2_2;
                void var1_1;
                this.zze.put(var1_1, var2_2);
                return (T)this;
            }
            zzfc.zze("HitBuilder.set() called with a null paramName.");
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final T setAll(@Nullable Map<String, String> params) {
            void var1_1;
            if (params == null) {
                return (T)this;
            }
            this.zze.putAll(new HashMap(var1_1));
            return (T)this;
        }

        /*
         * Unable to fully structure code
         */
        @NonNull
        public T setCampaignParamsFromUrl(@NonNull String utmParams) {
            block9: {
                if (TextUtils.isEmpty((CharSequence)utmParams)) {
                    var1_1 = null;
lbl3:
                    // 4 sources

                    while (true) {
                        if (TextUtils.isEmpty(var1_1)) {
                            return (T)this;
                        }
                        v0 = zzfu.zzf(var1_1);
                        var1_1 = (String)v0.get("utm_content");
                        this.zza("&cc", var1_1);
                        var1_1 = (String)v0.get("utm_medium");
                        this.zza("&cm", var1_1);
                        var1_1 = (String)v0.get("utm_campaign");
                        this.zza("&cn", var1_1);
                        var1_1 = (String)v0.get("utm_source");
                        this.zza("&cs", var1_1);
                        var1_1 = (String)v0.get("utm_term");
                        this.zza("&ck", var1_1);
                        var1_1 = (String)v0.get("utm_id");
                        this.zza("&ci", var1_1);
                        var1_1 = (String)v0.get("anid");
                        this.zza("&anid", var1_1);
                        var1_1 = (String)v0.get("gclid");
                        this.zza("&gclid", var1_1);
                        var1_1 = (String)v0.get("dclid");
                        this.zza("&dclid", var1_1);
                        var1_1 = (String)v0.get("aclid");
                        this.zza("&aclid", var1_1);
                        var1_1 = (String)v0.get("gmob_t");
                        this.zza("&gmob_t", var1_1);
                        return (T)this;
                    }
                }
                if (var1_1.contains("?") && ((String[])(var2_3 = var1_1.split("[\\?]"))).length > 1) {
                    var1_1 = var2_3[1];
                }
                if (!var1_1.contains("%3D")) break block9;
                try {
                    var1_1 = URLDecoder.decode(var1_1, "UTF-8");
                }
                catch (UnsupportedEncodingException v1) {
                    var1_1 = null;
                    ** continue;
                }
lbl46:
                // 2 sources

                while (true) {
                    var2_3 = "dclid";
                    var3_4 = zzfu.zzf(var1_1);
                    var4_5 = new String[]{var2_3, "utm_source", "gclid", "aclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "anid", "gmob_t"};
                    var2_3 = new StringBuilder();
                    for (var1_2 = 0; var1_2 < 11; ++var1_2) {
                        if (TextUtils.isEmpty((CharSequence)((CharSequence)var3_4.get(var4_5[var1_2])))) continue;
                        if (var2_3.length() > 0) {
                            var2_3.append("&");
                        }
                        var2_3.append(var4_5[var1_2]);
                        var2_3.append("=");
                        var2_3.append((String)var3_4.get(var4_5[var1_2]));
                    }
                    var1_1 = var2_3.toString();
                    ** GOTO lbl3
                    break;
                }
            }
            ** while (var1_1.contains((CharSequence)"="))
lbl67:
            // 1 sources

            var1_1 = null;
            ** GOTO lbl3
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T setCustomDimension(int index, @NonNull String dimension) {
            void var2_2;
            void var1_1;
            this.set(com.google.android.gms.analytics.zzd.zza((int)var1_1), (String)var2_2);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T setCustomMetric(int index, float metric) {
            void var2_2;
            void var1_1;
            this.set(com.google.android.gms.analytics.zzd.zzd((int)var1_1), Float.toString((float)var2_2));
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        protected T setHitType(@NonNull String hitType) {
            void var1_1;
            this.set("&t", (String)var1_1);
            return (T)this;
        }

        @NonNull
        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T setNonInteraction(boolean nonInteraction) {
            void var1_1;
            this.set("&ni", zzfu.zzc((boolean)var1_1));
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T setProductAction(@NonNull ProductAction action) {
            void var1_1;
            this.zza = var1_1;
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public T setPromotionAction(@NonNull String action) {
            void var1_1;
            this.zze.put("&promoa", var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @Nullable
        protected String get(@NonNull String paramName) {
            void var1_1;
            return (String)this.zze.get(var1_1);
        }

        @NonNull
        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.zze);
            ProductAction productAction = this.zza;
            if (productAction != null) {
                hashMap.putAll(productAction.zza());
            }
            Iterator<Object> iterator = this.zzc.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                hashMap.putAll(((Promotion)iterator.next()).zza(com.google.android.gms.analytics.zzd.zzl(n)));
                ++n;
            }
            iterator = this.zzd.iterator();
            n = 1;
            while (iterator.hasNext()) {
                hashMap.putAll(((Product)iterator.next()).zza(com.google.android.gms.analytics.zzd.zzj(n)));
                ++n;
            }
            iterator = this.zzb.entrySet().iterator();
            int n2 = 1;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = com.google.android.gms.analytics.zzd.zzg(n2);
                Iterator iterator2 = ((List)entry.getValue()).iterator();
                int n3 = 1;
                while (iterator2.hasNext()) {
                    hashMap.putAll(((Product)iterator2.next()).zza(string.concat(com.google.android.gms.analytics.zzd.zzi(n3))));
                    ++n3;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                    String string2 = (String)entry.getKey();
                    hashMap.put(string.concat("nm"), string2);
                }
                ++n2;
            }
            return hashMap;
        }

        protected HitBuilder() {
        }

        private final HitBuilder zza(String string, String string2) {
            if (string2 != null) {
                this.zze.put(string, string2);
            }
            return this;
        }
    }
}

