/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.common.internal.zzv;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzEf;

    public static boolean zzI(Context context) {
        zzv.zzr((Object)context);
        if (zzEf != null) {
            return zzEf;
        }
        boolean bl = zzal.zza(context, CampaignTrackingService.class);
        zzEf = bl;
        return bl;
    }

    public void onCreate() {
        super.onCreate();
        zze zze2 = zze.zzJ((Context)this);
        zzae zzae2 = zze2.zzgH();
        zzae2.zzaF("CampaignTrackingService is starting up");
    }

    public void onDestroy() {
        zze zze2 = zze.zzJ((Context)this);
        zzae zzae2 = zze2.zzgH();
        zzae2.zzaF("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, final int startId) {
        String string;
        this.zzfQ();
        zze zze2 = zze.zzJ((Context)this);
        final zzae zzae2 = zze2.zzgH();
        String string2 = null;
        if (zze2.zzgI().zzhP()) {
            zzae2.zzaJ("Unexpected installation campaign (package side)");
        } else {
            string2 = intent.getStringExtra("referrer");
        }
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!zze2.zzgI().zzhP()) {
                zzae2.zzaI("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            }
            zze2.zzgJ().zze(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zzae2, handler, startId);
                }
            });
            return 2;
        }
        int n = zze2.zzgI().zzhT();
        if (string2.length() <= n) {
            string = string2;
        } else {
            zzae2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n);
            string = string2.substring(0, n);
        }
        zzae2.zza("CampaignTrackingService called. startId, campaign", startId, string);
        zze2.zzfZ().zza(string, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zzae2, handler, startId);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfQ() {
        try {
            Object object = CampaignTrackingReceiver.zznu;
            synchronized (object) {
                PowerManager.WakeLock wakeLock = CampaignTrackingReceiver.zzEd;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void zza(final zzae zzae2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zzae2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

