/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzad;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzEs;
    private final Tracker zzEt;
    private final Context mContext;
    private ExceptionParser zzEu;
    private GoogleAnalytics zzEv;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzEs = originalHandler;
        this.zzEt = tracker;
        this.zzEu = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzad.zzam("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzEu;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzEu = exceptionParser;
    }

    GoogleAnalytics zzfT() {
        if (this.zzEv == null) {
            this.zzEv = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzEv;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzEu != null) {
            object = t != null ? t.getName() : null;
            string = this.zzEu.getDescription((String)object, e);
        }
        zzad.zzam("Reporting uncaught exception: " + string);
        this.zzEt.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzfT();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzfY();
        if (this.zzEs != null) {
            zzad.zzam("Passing exception to the original handler");
            this.zzEs.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzfU() {
        return this.zzEs;
    }
}

