/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzFo;
    private AdvertisingIdClient.Info zzFp;
    private final zzai zzFq;
    private String zzFr;
    private boolean zzFs = false;
    private Object zzFt = new Object();

    zza(zze zze2) {
        super(zze2);
        this.zzFq = new zzai(zze2.zzgG());
    }

    @Override
    protected void zzgb() {
    }

    public boolean zzgn() {
        this.zzgR();
        AdvertisingIdClient.Info info = this.zzgs();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zzgr() {
        this.zzgR();
        AdvertisingIdClient.Info info = this.zzgs();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zzgs() {
        if (this.zzFq.zzt(1000L)) {
            this.zzFq.start();
            AdvertisingIdClient.Info info = this.zzgt();
            if (this.zza(this.zzFp, info)) {
                this.zzFp = info;
            } else {
                this.zzaJ("Failed to reset client id on adid change. Not using adid");
                this.zzFp = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzFp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzgM().zzhI();
        Object object = this.zzFt;
        synchronized (object) {
            String string4;
            if (!this.zzFs) {
                this.zzFr = this.zzgu();
                this.zzFs = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzFr)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    return this.zzaE(string + string3);
                }
                this.zzFr = zza.zzaD(string4 + string3);
            }
            string4 = zza.zzaD(string + string3);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzFr)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzFr)) {
                this.zzaF("Resetting the client id because Advertising Id changed.");
                string3 = this.zzgM().zzhJ();
                this.zza("New client Id", string3);
            }
            return this.zzaE(string + string3);
        }
    }

    protected AdvertisingIdClient.Info zzgt() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo(this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzaI("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzFo) break block3;
                zzFo = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzaD(String string) {
        MessageDigest messageDigest = zzal.zzaX("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzaE(String string) {
        try {
            String string2 = zza.zzaD(string);
            this.zzaF("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzFr = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzgu() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzaI("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzaF("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

