/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzs;
import com.google.android.gms.analytics.internal.zzu;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzx;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzk
extends zzd {
    private boolean mStarted;
    private final zzi zzGr;
    private final zzag zzGs;
    private final zzaf zzGt;
    private final zzh zzGu;
    private long zzGv;
    private final zzs zzGw;
    private final zzs zzGx;
    private final zzai zzGy;
    private long zzGz;
    private boolean zzGA;

    protected zzk(zze zze2, zzf zzf2) {
        super(zze2);
        com.google.android.gms.common.internal.zzv.zzr((Object)zzf2);
        this.zzGv = Long.MIN_VALUE;
        this.zzGt = zzf2.zzk(zze2);
        this.zzGr = zzf2.zzm(zze2);
        this.zzGs = zzf2.zzn(zze2);
        this.zzGu = zzf2.zzo(zze2);
        this.zzGy = new zzai(this.zzgG());
        this.zzGw = new zzs(zze2){

            @Override
            public void run() {
                zzk.this.zzht();
            }
        };
        this.zzGx = new zzs(zze2){

            @Override
            public void run() {
                zzk.this.zzhu();
            }
        };
    }

    @Override
    protected void zzgb() {
        this.zzGr.zzfV();
        this.zzGs.zzfV();
        this.zzGu.zzfV();
    }

    void start() {
        this.zzgR();
        com.google.android.gms.common.internal.zzv.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zzgI().zzhP()) {
            this.zzhr();
        }
        this.zzgJ().zze(new Runnable(){

            @Override
            public void run() {
                zzk.this.zzhs();
            }
        });
    }

    private void zzhr() {
        boolean bl;
        zze zze2 = this.zzgD();
        Context context = zze2.getContext();
        boolean bl2 = AnalyticsReceiver.zzH(context);
        if (!bl2) {
            this.zzaI("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzI(context);
            if (!bl) {
                this.zzaJ("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzH(context);
        if (!bl) {
            this.zzaI("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzI(context);
            if (!bl3) {
                this.zzaI("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzaM(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzhs() {
        this.zzgR();
        this.zzgL().zzjd();
        if (!this.zzaM("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzaJ("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzhH();
        }
        if (!this.zzaM("android.permission.INTERNET")) {
            this.zzaJ("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzhH();
        }
        if (AnalyticsService.zzI(this.getContext())) {
            this.zzaF("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzgI().zzhP()) {
            this.zzaJ("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzaI("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzGA || this.zzgI().zzhP() || this.zzGr.isEmpty())) {
            this.zzhv();
        }
        this.zzhz();
    }

    private void zzht() {
        this.zzb(new zzv(){

            @Override
            public void zzc(Throwable throwable) {
                zzk.this.zzhz();
            }
        });
    }

    void zzgB() {
        this.zzgF();
        this.zzGz = this.zzgG().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzgF();
        if (!this.zzgI().zzhP()) {
            this.zzhw();
        }
    }

    public void zzgz() {
        zzkk.zzgF();
        this.zzgR();
        this.zzaF("Service disconnected");
    }

    public void zzG(boolean bl) {
        this.zzhz();
    }

    private void zzhu() {
        try {
            this.zzGr.zzhl();
            this.zzhz();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzGx.zzr(this.zzgI().zzir());
    }

    protected void zzc(zzg zzg2) {
        this.zzgF();
        this.zzb("Sending first hit to property", zzg2.zzhb());
        if (this.zzgL().zzje().zzt(this.zzgI().zziu())) {
            return;
        }
        String string = this.zzgL().zzjh();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzkq zzkq2 = zzal.zza(this.zzgH(), string);
        this.zzb("Found relevant installation campaign", zzkq2);
        this.zza(zzg2, zzkq2);
    }

    public void zzq(long l) {
        zzkk.zzgF();
        this.zzgR();
        if (l < 0L) {
            l = 0L;
        }
        this.zzGv = l;
        this.zzhz();
    }

    protected void zzhv() {
        if (this.zzGA) {
            return;
        }
        if (!this.zzgI().zzhR()) {
            return;
        }
        if (this.zzGu.isConnected()) {
            return;
        }
        long l = this.zzgI().zzim();
        if (this.zzGy.zzt(l)) {
            this.zzGy.start();
            this.zzaF("Connecting to service");
            if (this.zzGu.connect()) {
                this.zzaF("Connected to service");
                this.zzGy.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzg zzg2, boolean bl) {
        com.google.android.gms.common.internal.zzv.zzr((Object)zzg2);
        this.zzgR();
        this.zzgF();
        long l = -1L;
        try {
            this.zzGr.beginTransaction();
            this.zzGr.zza(zzg2.zzha(), zzg2.getClientId());
            l = this.zzGr.zza(zzg2.zzha(), zzg2.getClientId(), zzg2.zzhb());
            if (!bl) {
                zzg2.zzl(l);
            } else {
                zzg2.zzl(l + 1L);
            }
            this.zzGr.zzb(zzg2);
            this.zzGr.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return l2;
        }
        finally {
            try {
                this.zzGr.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzaa zzaa2) {
        com.google.android.gms.common.internal.zzv.zzr((Object)zzaa2);
        zzkk.zzgF();
        this.zzgR();
        if (this.zzGA) {
            this.zzaG("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzaa2);
        }
        zzaa2 = this.zzf(zzaa2);
        this.zzhv();
        if (this.zzGu.zzb(zzaa2)) {
            this.zzaG("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzgI().zzhP()) {
            this.zzgH().zza(zzaa2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzGr.zzc(zzaa2);
            this.zzhz();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzgH().zza(zzaa2, "deliver: failed to insert hit to database");
        }
    }

    public void zzgv() {
        zzkk.zzgF();
        this.zzgR();
        if (!this.zzgI().zzhP()) {
            this.zzaF("Delete all hits from local store");
            try {
                this.zzGr.zzhj();
                this.zzGr.zzhk();
                this.zzhz();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzhv();
        if (this.zzGu.zzhf()) {
            this.zzaF("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzaa zzf(zzaa zzaa2) {
        if (!TextUtils.isEmpty((CharSequence)zzaa2.zziT())) {
            return zzaa2;
        }
        zzah.zza zza2 = this.zzgL().zzji();
        Pair<String, Long> pair = zza2.zzjl();
        if (pair == null) {
            return zzaa2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        String string2 = l + ":" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzaa2.zzhe());
        hashMap.put("_m", string2);
        return zzaa.zza(this, zzaa2, hashMap);
    }

    public void zzhw() {
        zzkk.zzgF();
        this.zzgR();
        this.zzgE();
        if (!this.zzgI().zzhR()) {
            this.zzaI("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzGu.isConnected()) {
            this.zzaF("Service not connected");
            return;
        }
        if (this.zzGr.isEmpty()) {
            return;
        }
        this.zzaF("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzaa> list;
            try {
                list = this.zzGr.zzn(this.zzgI().zzia());
                if (list.isEmpty()) {
                    this.zzhz();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzhD();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzaa zzaa2 = list.get(0);
                if (!this.zzGu.zzb(zzaa2)) {
                    this.zzhz();
                    return;
                }
                list.remove(zzaa2);
                try {
                    this.zzGr.zzo(zzaa2.zziO());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzhD();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzhx() {
        boolean bl;
        zzkk.zzgF();
        this.zzgR();
        this.zzaF("Dispatching a batch of local hits");
        boolean bl2 = !this.zzGu.isConnected() && !this.zzgI().zzhP();
        boolean bl3 = bl = !this.zzGs.zziZ();
        if (bl2 && bl) {
            this.zzaF("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzgI().zzia(), this.zzgI().zzib());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzaa> list;
                block38: {
                    this.zzGr.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzGr.zzn(l);
                        if (!list.isEmpty()) break block38;
                        this.zzaF("Store is empty, nothing to dispatch");
                        this.zzhD();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzhD();
                        boolean bl5 = false;
                        try {
                            this.zzGr.setTransactionSuccessful();
                            this.zzGr.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzhD();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzaa)object).zziO() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzhD();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzGu.isConnected() && !this.zzgI().zzhP()) {
                    this.zzaF("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzGu.zzb((zzaa)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzaa)object2).zziO());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzGr.zzo(((zzaa)object2).zziO());
                            arrayList.add(((zzaa)object2).zziO());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzhD();
                            boolean bl7 = false;
                            try {
                                this.zzGr.setTransactionSuccessful();
                                this.zzGr.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzhD();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzGs.zziZ()) {
                    object2 = this.zzGs.zzg(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzGr.zze((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzhD();
                        boolean bl8 = false;
                        try {
                            this.zzGr.setTransactionSuccessful();
                            this.zzGr.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzhD();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzGr.setTransactionSuccessful();
                    this.zzGr.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzhD();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzv zzv2) {
        this.zza(zzv2, this.zzGz);
    }

    public void zza(final zzv zzv2, final long l) {
        block8: {
            zzkk.zzgF();
            this.zzgR();
            long l2 = -1L;
            long l3 = this.zzgL().zzjf();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzgG().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzgI().zzhP()) {
                this.zzhv();
            }
            try {
                boolean bl = this.zzhx();
                if (bl) {
                    this.zzgJ().zze(new Runnable(){

                        @Override
                        public void run() {
                            zzk.this.zza(zzv2, l);
                        }
                    });
                } else {
                    this.zzgL().zzjg();
                    this.zzhz();
                    if (zzv2 != null) {
                        zzv2.zzc(null);
                    }
                    if (this.zzGz != l) {
                        this.zzGt.zziY();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzgL().zzjg();
                this.zzhz();
                if (zzv2 == null) break block8;
                zzv2.zzc(throwable);
            }
        }
    }

    public void zzhy() {
        zzkk.zzgF();
        this.zzgR();
        this.zzaG("Sync dispatching local hits");
        long l = this.zzGz;
        if (!this.zzgI().zzhP()) {
            this.zzhv();
        }
        try {
            while (this.zzhx()) {
            }
            this.zzgL().zzjg();
            this.zzhz();
            if (this.zzGz != l) {
                this.zzGt.zziY();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzhz();
        }
    }

    public long zzhm() {
        zzkk.zzgF();
        this.zzgR();
        try {
            return this.zzGr.zzhm();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzhz() {
        boolean bl;
        this.zzgD().zzgF();
        this.zzgR();
        if (!this.zzhA()) {
            this.zzGt.unregister();
            this.zzhD();
            return;
        }
        if (this.zzGr.isEmpty()) {
            this.zzGt.unregister();
            this.zzhD();
            return;
        }
        if (!zzx.zzHM.get().booleanValue()) {
            this.zzGt.zziW();
            bl = this.zzGt.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzhC();
        } else {
            this.zzhD();
            this.zzhB();
        }
    }

    private boolean zzhA() {
        if (this.zzGA) {
            return false;
        }
        if (this.zzgI().zzhP() && !this.zzgI().zzhQ()) {
            return false;
        }
        return this.zzhG() > 0L;
    }

    private void zzhB() {
        long l;
        long l2;
        long l3;
        zzu zzu2 = this.zzgK();
        if (!zzu2.zziz()) {
            return;
        }
        if (!zzu2.zzaK() && (l3 = this.zzhm()) != 0L && (l2 = Math.abs((l = this.zzgG().currentTimeMillis()) - l3)) <= this.zzgI().zzhZ()) {
            long l4 = this.zzgI().zzhY();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzu2.zziA();
        }
    }

    private void zzhC() {
        long l;
        long l2;
        this.zzhB();
        long l3 = this.zzhG();
        long l4 = this.zzgL().zzjf();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzgG().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzgI().zzhW(), l3)) : Math.min(this.zzgI().zzhW(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzGw.zzaK()) {
            l = Math.max(1L, l5 + this.zzGw.zziw());
            this.zzGw.zzs(l);
        } else {
            this.zzGw.zzr(l5);
        }
    }

    private void zzhD() {
        this.zzhE();
        this.zzhF();
    }

    private void zzhE() {
        if (this.zzGw.zzaK()) {
            this.zzaF("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzGw.cancel();
    }

    private void zzhF() {
        zzu zzu2 = this.zzgK();
        if (zzu2.zzaK()) {
            zzu2.cancel();
        }
    }

    public long zzhG() {
        if (this.zzGv != Long.MIN_VALUE) {
            return this.zzGv;
        }
        long l = this.zzgI().zzhX();
        if (this.zzga().zziJ()) {
            l = (long)this.zzga().zzjB() * 1000L;
        }
        return l;
    }

    public void zzaN(String string) {
        com.google.android.gms.common.internal.zzv.zzbS((String)string);
        this.zzgF();
        this.zzgE();
        zzkq zzkq2 = zzal.zza(this.zzgH(), string);
        if (zzkq2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzgL().zzjh();
        if (string.equals(string2)) {
            this.zzaI("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzgL().zzaR(string);
        if (this.zzgL().zzje().zzt(this.zzgI().zziu())) {
            this.zzd("Campaign received too late, ignoring", zzkq2);
            return;
        }
        this.zzb("Received installation campaign", zzkq2);
        List<zzg> list = this.zzGr.zzp(0L);
        for (zzg zzg2 : list) {
            this.zza(zzg2, zzkq2);
        }
    }

    private void zza(zzg zzg2, zzkq zzkq2) {
        com.google.android.gms.common.internal.zzv.zzr((Object)zzg2);
        com.google.android.gms.common.internal.zzv.zzr((Object)zzkq2);
        zza zza2 = new zza(this.zzgD());
        zza2.zzat(zzg2.zzhb());
        zza2.enableAdvertisingIdCollection(zzg2.zzhc());
        zzkg zzkg2 = zza2.zzfP();
        zzgp zzgp2 = zzkg2.zze(zzgp.class);
        zzgp2.zzay("data");
        zzgp2.zzF(true);
        zzkg2.zzb(zzkq2);
        zzgo zzgo2 = zzkg2.zze(zzgo.class);
        zzkp zzkp2 = zzkg2.zze(zzkp.class);
        for (Map.Entry<String, String> entry : zzg2.zzhe().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzkp2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzkp2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzkp2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzkp2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzgp2.zzaz(string2);
                continue;
            }
            zzgo2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzg2.zzhb(), zzkq2);
        zzkg2.zzK(this.zzgL().zzjd());
        zzkg2.zzud();
    }

    public void zzhH() {
        this.zzgR();
        this.zzgF();
        this.zzGA = true;
        this.zzGu.disconnect();
        this.zzhz();
    }
}

