/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.common.internal.zzv;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzm
extends zzd {
    private volatile String zzFg;
    private Future<String> zzGK;

    protected zzm(zze zze2) {
        super(zze2);
    }

    @Override
    protected void zzgb() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzhI() {
        this.zzgR();
        zzm zzm2 = this;
        synchronized (zzm2) {
            if (this.zzFg == null) {
                this.zzGK = this.zzgJ().zzb(new Callable<String>(){

                    public String zzhN() throws Exception {
                        return zzm.this.zzhK();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzhN();
                    }
                });
            }
            if (this.zzGK != null) {
                try {
                    this.zzFg = this.zzGK.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzFg = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzFg = "0";
                }
                if (this.zzFg == null) {
                    this.zzFg = "0";
                }
                this.zza("Loaded clientId", this.zzFg);
                this.zzGK = null;
            }
            return this.zzFg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzhJ() {
        zzm zzm2 = this;
        synchronized (zzm2) {
            this.zzFg = null;
            this.zzGK = this.zzgJ().zzb(new Callable<String>(){

                public String zzhN() throws Exception {
                    return zzm.this.zzhL();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzhN();
                }
            });
        }
        return this.zzhI();
    }

    String zzhK() {
        String string = this.zzL(this.zzgJ().getContext());
        if (string == null) {
            string = this.zzhL();
        }
        return string;
    }

    private String zzhL() {
        String string = this.zzhM();
        try {
            if (!this.zzg(this.zzgJ().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzhM() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzL(Context context) {
        zzv.zzbJ((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                this.zzaI("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            if (n < 14) {
                this.zzaI("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            String string = null;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzg(Context context, String string) {
        zzv.zzbS((String)string);
        zzv.zzbJ((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

