/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzmy;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class zzmz
implements Runnable {
    private final Context mContext;
    private final zzmy zzaHO;
    private final zzmx zzaEE;
    private final zzmo zzaHH;
    private final zzmt zzaHP;

    public zzmz(Context context, zzmo zzmo2, zzmy zzmy2) {
        this(context, zzmo2, zzmy2, new zzmx(), new zzmt());
    }

    public zzmz(Context context, zzmo zzmo2, zzmy zzmy2, String string) {
        this(context, zzmo2, zzmy2, new zzmx(), new zzmt());
        this.zzaHP.zzem(string);
    }

    zzmz(Context context, zzmo zzmo2, zzmy zzmy2, zzmx zzmx2, zzmt zzmt2) {
        zzv.zzr((Object)context);
        zzv.zzr((Object)zzmy2);
        this.mContext = context;
        this.zzaHH = zzmo2;
        this.zzaHO = zzmy2;
        this.zzaEE = zzmx2;
        this.zzaHP = zzmt2;
    }

    @Override
    public void run() {
        this.zzdF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void zzdF() {
        block11: {
            if (!this.zzyO()) {
                this.zzaHO.zza(zzmy.zza.zzaHJ);
                return;
            }
            zzbg.zzam("NetworkLoader: Starting to load resource from Network.");
            InputStream inputStream = null;
            try (zzmw zzmw2 = this.zzaEE.zzyM();){
                String string = this.zzaHP.zzu(this.zzaHH.zzyl());
                try {
                    inputStream = zzmw2.zzev(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzak("NetworkLoader: No data is retrieved from the given url: " + string);
                    this.zzaHO.zza(zzmy.zza.zzaHL);
                    zzmw2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when loading resource from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaHO.zza(zzmy.zza.zzaHK);
                    zzmw2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzhy.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    this.zzaHO.zzq(byteArrayOutputStream.toByteArray());
                    break block11;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaHO.zza(zzmy.zza.zzaHL);
                    zzmw2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.zzam("NetworkLoader: Resource loaded.");
    }

    boolean zzyO() {
        if (!this.zzaM("android.permission.INTERNET")) {
            zzbg.zzak("Missing android.permission.INTERNET. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (!this.zzaM("android.permission.ACCESS_NETWORK_STATE")) {
            zzbg.zzak("Missing android.permission.ACCESS_NETWORK_STATE. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />");
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.zzan("NetworkLoader: No network connectivity - Offline");
            return false;
        }
        return true;
    }

    boolean zzaM(String string) {
        return this.mContext.getPackageManager().checkPermission(string, this.mContext.getPackageName()) == 0;
    }
}

