/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzf;
import com.google.android.gms.common.stats.zzh;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzma;

public class zzqd {
    private static String TAG = "WakeLock";
    private static boolean DEBUG = false;
    private final PowerManager.WakeLock zzaOu;
    private WorkSource zzaOv;
    private final int zzaOw;
    private final String zzafS;
    private final String zzaOx;
    private final Context mContext;
    private boolean zzaOy = true;
    private int zzaOz;
    private int zzaOA;

    public zzqd(Context context, int n, String string, String string2, String string3) {
        zzx.zzh((String)string, (Object)"Wake lock name can NOT be empty");
        this.zzaOw = n;
        this.zzafS = string;
        this.zzaOx = string2;
        this.mContext = context.getApplicationContext();
        this.zzaOu = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string);
        if (zzma.zzaq((Context)this.mContext)) {
            String string4;
            if (zzlz.zzcB((String)string3)) {
                if (zzd.zzacF && zzkq.isInitialized()) {
                    Log.e((String)TAG, (String)("callingPackage is not supposed to be empty for wakelock " + this.zzafS + "!"));
                    string4 = "com.google.android.gms";
                } else {
                    string4 = context.getPackageName();
                }
            } else {
                string4 = string3;
            }
            this.zzaOv = zzma.zzj((Context)context, (String)string4);
            this.zzc(this.zzaOv);
        }
    }

    public zzqd(Context context, int n, String string) {
        this(context, n, string, null, null);
    }

    public void acquire(long timeout) {
        if (!zzlv.zzpR() && this.zzaOy) {
            Log.wtf((String)TAG, (String)("Do not acquire with timeout on reference counted WakeLocks before ICS. wakelock: " + this.zzafS));
        }
        this.zzen(null);
        this.zzaOu.acquire(timeout);
    }

    public void release() {
        this.zzeo(null);
        this.zzaOu.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzen(String string) {
        boolean bl = this.zzep(string);
        String string2 = this.zzi(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Acquire:\n mWakeLockName: " + this.zzafS + "\n mSecondaryName: " + this.zzaOx + "\nmReferenceCounted: " + this.zzaOy + "\nreason: " + string + "\nmOpenEventCount" + this.zzaOA + "\nuseWithReason: " + bl + "\ntrackingName: " + string2));
        }
        zzqd zzqd2 = this;
        synchronized (zzqd2) {
            if (this.zzaOy && (this.zzaOz++ == 0 || bl) || !this.zzaOy && this.zzaOA == 0) {
                zzh.zzpL().zza(this.mContext, zzf.zza((PowerManager.WakeLock)this.zzaOu, (String)string2), 7, this.zzafS, string2, this.zzaOw, zzma.zzb((WorkSource)this.zzaOv));
                ++this.zzaOA;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeo(String string) {
        boolean bl = this.zzep(string);
        String string2 = this.zzi(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Release:\n mWakeLockName: " + this.zzafS + "\n mSecondaryName: " + this.zzaOx + "\nmReferenceCounted: " + this.zzaOy + "\nreason: " + string + "\n mOpenEventCount" + this.zzaOA + "\nuseWithReason: " + bl + "\ntrackingName: " + string2));
        }
        zzqd zzqd2 = this;
        synchronized (zzqd2) {
            if (this.zzaOy && (--this.zzaOz == 0 || bl) || !this.zzaOy && this.zzaOA == 1) {
                zzh.zzpL().zza(this.mContext, zzf.zza((PowerManager.WakeLock)this.zzaOu, (String)string2), 8, this.zzafS, string2, this.zzaOw, zzma.zzb((WorkSource)this.zzaOv));
                --this.zzaOA;
            }
        }
    }

    private boolean zzep(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzaOx);
    }

    private String zzi(String string, boolean bl) {
        return this.zzaOy ? (bl ? string : this.zzaOx) : this.zzaOx;
    }

    public void setReferenceCounted(boolean value) {
        this.zzaOu.setReferenceCounted(value);
        this.zzaOy = value;
    }

    public boolean isHeld() {
        return this.zzaOu.isHeld();
    }

    public void zzc(WorkSource workSource) {
        if (zzma.zzaq((Context)this.mContext) && workSource != null) {
            if (this.zzaOv != null) {
                this.zzaOv.add(workSource);
            } else {
                this.zzaOv = workSource;
            }
            this.zzaOu.setWorkSource(this.zzaOv);
        }
    }
}

