/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;

class zzag
extends BroadcastReceiver {
    static final String zzPu = zzag.class.getName();
    private final zzf zzME;
    private boolean zzPv;
    private boolean zzPw;

    zzag(zzf zzf2) {
        zzx.zzw((Object)zzf2);
        this.zzME = zzf2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zzkI();
        String string = intent.getAction();
        this.zzME.zziu().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzkK();
            if (this.zzPw != bl) {
                this.zzPw = bl;
                this.zzhP().zzI(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzPu)) {
                this.zzhP().zzio();
            }
            return;
        }
        this.zzME.zziu().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzkH() {
        this.zzkI();
        if (this.zzPv) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzPw = this.zzkK();
        this.zzME.zziu().zza("Registering connectivity change receiver. Network connected", this.zzPw);
        this.zzPv = true;
    }

    private void zzkI() {
        this.zziu();
        this.zzhP();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzME.zziu().zzba("Unregistering connectivity change receiver");
        this.zzPv = false;
        this.zzPw = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zziu().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzkJ() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzPu, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzPv;
    }

    public boolean isConnected() {
        if (!this.zzPv) {
            this.zzME.zziu().zzbd("Connectivity unknown. Receiver not registered");
        }
        return this.zzPw;
    }

    protected boolean zzkK() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzME.getContext();
    }

    private zzaf zziu() {
        return this.zzME.zziu();
    }

    private zzb zzhP() {
        return this.zzME.zzhP();
    }
}

