/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzNc;
    private zzac zzNd;
    private final zzt zzNe;
    private zzaj zzNf;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzNf = new zzaj(zzf2.zzit());
        this.zzNc = new zza();
        this.zzNe = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zziS();
            }
        };
    }

    @Override
    protected void zzhR() {
    }

    public boolean isConnected() {
        this.zzis();
        this.zziE();
        return this.zzNd != null;
    }

    public boolean zzb(zzab zzab2) {
        zzx.zzw((Object)zzab2);
        this.zzis();
        this.zziE();
        zzac zzac2 = this.zzNd;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zzkC() ? this.zziv().zzjO() : this.zziv().zzjP();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzn(), zzab2.zzkA(), string, list);
            this.zziR();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzba("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zziQ() {
        this.zzis();
        this.zziE();
        zzac zzac2 = this.zzNd;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzik();
            this.zziR();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzba("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zziR() {
        this.zzNf.start();
        this.zzNe.zzt(this.zziv().zzjV());
    }

    public boolean connect() {
        this.zzis();
        this.zziE();
        if (this.zzNd != null) {
            return true;
        }
        zzac zzac2 = this.zzNc.zziT();
        if (zzac2 != null) {
            this.zzNd = zzac2;
            this.zziR();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzis();
        this.zzNd = zzac2;
        this.zziR();
        this.zzhP().onServiceConnected();
    }

    public void disconnect() {
        this.zzis();
        this.zziE();
        try {
            zzb zzb2 = zzb.zzqh();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzNc);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzNd != null) {
            this.zzNd = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzis();
        if (this.zzNd != null) {
            this.zzNd = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zziS() {
        this.zzis();
        if (!this.isConnected()) {
            return;
        }
        this.zzba("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzhP().zzin();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzNh;
        private volatile boolean zzNi;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zziT() {
            zzi.this.zzis();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzqh();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzNh = null;
                this.zzNi = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.zzNc, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzNi = false;
                    return null;
                }
                try {
                    long l = zzi.this.zziv().zzjW();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzbd("Wait for service connect was interrupted");
                }
                this.zzNi = false;
                zzac zzac2 = this.zzNh;
                this.zzNh = null;
                if (zzac2 == null) {
                    zzi.this.zzbe("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzci((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzi.this.zzbe("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzaf(binder);
                            zzi.this.zzba("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzbe("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzqh().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.zzNc);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzNi) {
                        zzi.this.zzbd("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zziw().zzg(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzNj;
                            {
                                this.zzNj = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzbb("Connected to service after a timeout");
                                    zzi.this.zza(this.zzNj);
                                }
                            }
                        });
                    } else {
                        this.zzNh = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzci((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zziw().zzg(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

