/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzaVQ;
    private final DataLayer zzaVR;
    private zzcp zzaVS;
    private Map<String, FunctionCallMacroCallback> zzaVT = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzaVU = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzaVV;
    private volatile String zzaVW = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzrb.zzc resource) {
        this.mContext = context;
        this.zzaVR = dataLayer;
        this.zzaVQ = containerId;
        this.zzaVV = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzaf.zzj resource) {
        this.mContext = context;
        this.zzaVR = dataLayer;
        this.zzaVQ = containerId;
        this.zzaVV = lastRefreshTime;
        this.zza(resource.zziR);
        if (resource.zziQ != null) {
            this.zza(resource.zziQ);
        }
    }

    public String getContainerId() {
        return this.zzaVQ;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzCu();
        if (zzcp2 == null) {
            zzbg.e("getBoolean called for closed container.");
            return zzdf.zzDU();
        }
        try {
            return zzdf.zzk(zzcp2.zzeY(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzDU();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzCu();
        if (zzcp2 == null) {
            zzbg.e("getDouble called for closed container.");
            return zzdf.zzDT();
        }
        try {
            return zzdf.zzj(zzcp2.zzeY(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzDT();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzCu();
        if (zzcp2 == null) {
            zzbg.e("getLong called for closed container.");
            return zzdf.zzDS();
        }
        try {
            return zzdf.zzi(zzcp2.zzeY(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzDS();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzCu();
        if (zzcp2 == null) {
            zzbg.e("getString called for closed container.");
            return zzdf.zzDW();
        }
        try {
            return zzdf.zzg(zzcp2.zzeY(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzDW();
        }
    }

    public long getLastRefreshTime() {
        return this.zzaVV;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzaVT;
        synchronized (map) {
            this.zzaVT.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzaVT;
        synchronized (map) {
            this.zzaVT.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzeA(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzaVT;
        synchronized (map) {
            return this.zzaVT.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzaVU;
        synchronized (map) {
            this.zzaVU.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzaVU;
        synchronized (map) {
            this.zzaVU.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback zzeB(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzaVU;
        synchronized (map) {
            return this.zzaVU.get(string);
        }
    }

    void zzeC(String string) {
        this.zzCu().zzeC(string);
    }

    String zzCt() {
        return this.zzaVW;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzrb.zzc zzc2 = null;
        try {
            zzc2 = zzrb.zzb(zzf2);
        }
        catch (zzrb.zzg zzg2) {
            zzbg.e("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzCu().zzA(arrayList);
    }

    private void zza(zzrb.zzc zzc2) {
        this.zzaVW = zzc2.getVersion();
        zzah zzah2 = this.zzeD(this.zzaVW);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzaVR, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzaVR.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzaVQ));
        }
    }

    zzah zzeD(String string) {
        if (zzcb.zzDm().zzDn().equals((Object)zzcb.zza.zzaYa)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzaVS = zzcp2;
    }

    private synchronized zzcp zzCu() {
        return this.zzaVS;
    }

    void release() {
        this.zzaVS = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzeB(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzDW();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzeA(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

