/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzrg zzaYi;
    private final String zzaVQ;
    private final String zzaYj;
    private zzbf<zzaf.zzj> zzaYk;
    private volatile zzs zzaYl;
    private volatile String zzaWn;
    private volatile String zzaYm;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzrg(), zzs2);
    }

    zzcl(Context context, String string, zzrg zzrg2, zzs zzs2) {
        this.mContext = context;
        this.zzaYi = zzrg2;
        this.zzaVQ = string;
        this.zzaYl = zzs2;
        this.zzaWn = this.zzaYj = "/r?id=" + string;
        this.zzaYm = null;
    }

    @Override
    public void run() {
        if (this.zzaYk == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzaYk.zzCC();
        this.zzDq();
    }

    private boolean zzDp() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzaf.zzj> zzbf2) {
        this.zzaYk = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzDq() {
        block12: {
            if (!this.zzDp()) {
                this.zzaYk.zza(zzbf.zza.zzaXy);
                return;
            }
            zzbg.v("Start loading resource from network ...");
            String string = this.zzDr();
            InputStream inputStream = null;
            try (zzrf zzrf2 = this.zzaYi.zzEt();){
                try {
                    inputStream = zzrf2.zzft(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaH("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzaVQ + " is correct.");
                    this.zzaYk.zza(zzbf.zza.zzaXA);
                    zzrf2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaYk.zza(zzbf.zza.zzaXz);
                    zzrf2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzrb.zzb(inputStream, byteArrayOutputStream);
                    zzaf.zzj zzj2 = zzaf.zzj.zzd(byteArrayOutputStream.toByteArray());
                    zzbg.v("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zziR == null && zzj2.zziQ.length == 0) {
                        zzbg.v("No change for container: " + this.zzaVQ);
                    }
                    this.zzaYk.zzH(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaYk.zza(zzbf.zza.zzaXA);
                    zzrf2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.v("Load resource from network finished.");
    }

    String zzDr() {
        String string = this.zzaYl.zzCE() + this.zzaWn + "&v=a65833898";
        if (this.zzaYm != null && !this.zzaYm.trim().equals("")) {
            string = string + "&pv=" + this.zzaYm;
        }
        if (zzcb.zzDm().zzDn().equals((Object)zzcb.zza.zzaYa)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzeH(String string) {
        if (string == null) {
            this.zzaWn = this.zzaYj;
        } else {
            zzbg.zzaF("Setting CTFE URL path: " + string);
            this.zzaWn = string;
        }
    }

    void zzeW(String string) {
        zzbg.zzaF("Setting previous container version: " + string);
        this.zzaYm = string;
    }
}

