/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzNG;
    private final Tracker zzNH;
    private final Context mContext;
    private ExceptionParser zzNI;
    private GoogleAnalytics zzNJ;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzNG = originalHandler;
        this.zzNH = tracker;
        this.zzNI = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.v("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzNI;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzNI = exceptionParser;
    }

    GoogleAnalytics zzik() {
        if (this.zzNJ == null) {
            this.zzNJ = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzNJ;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzNI != null) {
            object = t != null ? t.getName() : null;
            string = this.zzNI.getDescription((String)object, e);
        }
        zzae.v("Reporting uncaught exception: " + string);
        this.zzNH.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzik();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzio();
        if (this.zzNG != null) {
            zzae.v("Passing exception to the original handler");
            this.zzNG.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzil() {
        return this.zzNG;
    }
}

