/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzPn;
    private zzac zzPo;
    private final zzt zzPp;
    private zzaj zzPq;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzPq = new zzaj(zzf2.zziT());
        this.zzPn = new zza();
        this.zzPp = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zzjs();
            }
        };
    }

    @Override
    protected void zzir() {
    }

    public boolean isConnected() {
        this.zziS();
        this.zzje();
        return this.zzPo != null;
    }

    public boolean zzb(zzab zzab2) {
        zzx.zzy((Object)zzab2);
        this.zziS();
        this.zzje();
        zzac zzac2 = this.zzPo;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zzlc() ? this.zziV().zzko() : this.zziV().zzkp();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzn(), zzab2.zzla(), string, list);
            this.zzjr();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzba("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzjq() {
        this.zziS();
        this.zzje();
        zzac zzac2 = this.zzPo;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zziK();
            this.zzjr();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzba("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzjr() {
        this.zzPq.start();
        this.zzPp.zzt(this.zziV().zzkv());
    }

    public boolean connect() {
        this.zziS();
        this.zzje();
        if (this.zzPo != null) {
            return true;
        }
        zzac zzac2 = this.zzPn.zzjt();
        if (zzac2 != null) {
            this.zzPo = zzac2;
            this.zzjr();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zziS();
        this.zzPo = zzac2;
        this.zzjr();
        this.zzip().onServiceConnected();
    }

    public void disconnect() {
        this.zziS();
        this.zzje();
        try {
            zzb zzb2 = zzb.zzrz();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzPn);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzPo != null) {
            this.zzPo = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zziS();
        if (this.zzPo != null) {
            this.zzPo = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zzjs() {
        this.zziS();
        if (!this.isConnected()) {
            return;
        }
        this.zzba("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzip().zziN();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzPs;
        private volatile boolean zzPt;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zzjt() {
            zzi.this.zziS();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzrz();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzPs = null;
                this.zzPt = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.zzPn, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzPt = false;
                    return null;
                }
                try {
                    long l = zzi.this.zziV().zzkw();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzbd("Wait for service connect was interrupted");
                }
                this.zzPt = false;
                zzac zzac2 = this.zzPs;
                this.zzPs = null;
                if (zzac2 == null) {
                    zzi.this.zzbe("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzcx((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzi.this.zzbe("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzaf(binder);
                            zzi.this.zzba("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzbe("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzrz().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.zzPn);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzPt) {
                        zzi.this.zzbd("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zziW().zzf(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzPu;
                            {
                                this.zzPu = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzbb("Connected to service after a timeout");
                                    zzi.this.zza(this.zzPu);
                                }
                            }
                        });
                    } else {
                        this.zzPs = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzcx((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zziW().zzf(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

