/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.measurement.zzi;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzi {
    private static DecimalFormat zzNA;
    private final zzf zzNq;
    private final String zzNB;
    private final Uri zzNC;
    private final boolean zzND;
    private final boolean zzNE;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzx.zzcG((String)string);
        this.zzNq = zzf2;
        this.zzNB = string;
        this.zzND = bl;
        this.zzNE = bl2;
        this.zzNC = zzb.zzaR(this.zzNB);
    }

    static Uri zzaR(String string) {
        zzx.zzcG((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzii() {
        return this.zzNC;
    }

    @Override
    public void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzy((Object)zzc2);
        zzx.zzb((boolean)zzc2.zzzJ(), (Object)"Can't deliver not submitted measurement");
        zzx.zzcy((String)"deliver should be called on worker thread");
        com.google.android.gms.measurement.zzc zzc3 = zzc2.zzzE();
        zzkc zzkc2 = zzc3.zze(zzkc.class);
        if (TextUtils.isEmpty((CharSequence)zzkc2.zziA())) {
            this.zziU().zzh(zzb.zzc(zzc3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzkc2.getClientId())) {
            this.zziU().zzh(zzb.zzc(zzc3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzNq.zzji().getAppOptOut()) {
            return;
        }
        double d = zzkc2.zziF();
        if (zzam.zza(d, zzkc2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzc3);
        map.put("v", "1");
        map.put("_v", zze.zzOS);
        map.put("tid", this.zzNB);
        if (this.zzNq.zzji().isDryRunEnabled()) {
            String string = zzb.zzA(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzam.zzc(hashMap, "uid", zzkc2.getUserId());
        zzqh zzqh2 = zzc2.zzd(zzqh.class);
        if (zzqh2 != null) {
            zzam.zzc(hashMap, "an", zzqh2.zzkP());
            zzam.zzc(hashMap, "aid", zzqh2.zzwg());
            zzam.zzc(hashMap, "av", zzqh2.zzkR());
            zzam.zzc(hashMap, "aiid", zzqh2.zzzT());
        }
        zzh zzh2 = new zzh(0L, zzkc2.getClientId(), this.zzNB, !TextUtils.isEmpty((CharSequence)zzkc2.zziB()), 0L, hashMap);
        long l = this.zzip().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zziU(), map, zzc2.zzzH(), true);
        this.zzip().zza(zzab2);
    }

    public static Map<String, String> zzc(com.google.android.gms.measurement.zzc zzc2) {
        zzqh zzqh2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzjz zzjz2;
        zzqp zzqp2;
        zzqo zzqo2;
        zzqm zzqm2;
        zzqi zzqi2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzkb zzkb2 = zzc2.zzd(zzkb.class);
        if (zzkb2 != null) {
            object7 = zzkb2.zziz().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzh(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzc2.zzd(zzkc.class)) != null) {
            zzb.zzb(hashMap, "t", ((zzkc)object7).zziA());
            zzb.zzb(hashMap, "cid", ((zzkc)object7).getClientId());
            zzb.zzb(hashMap, "uid", ((zzkc)object7).getUserId());
            zzb.zzb(hashMap, "sc", ((zzkc)object7).zziD());
            zzb.zza(hashMap, "sf", ((zzkc)object7).zziF());
            zzb.zza(hashMap, "ni", ((zzkc)object7).zziE());
            zzb.zzb(hashMap, "adid", ((zzkc)object7).zziB());
            zzb.zza(hashMap, "ate", ((zzkc)object7).zziC());
        }
        if ((object6 = zzc2.zzd(zzqn.class)) != null) {
            zzb.zzb(hashMap, "cd", ((zzqn)object6).zzAm());
            zzb.zza(hashMap, "a", ((zzqn)object6).zzAn());
            zzb.zzb(hashMap, "dr", ((zzqn)object6).zzAo());
        }
        if ((object5 = zzc2.zzd(zzql.class)) != null) {
            zzb.zzb(hashMap, "ec", ((zzql)object5).zzAj());
            zzb.zzb(hashMap, "ea", ((zzql)object5).getAction());
            zzb.zzb(hashMap, "el", ((zzql)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzql)object5).getValue());
        }
        if ((zzqi2 = zzc2.zzd(zzqi.class)) != null) {
            zzb.zzb(hashMap, "cn", zzqi2.getName());
            zzb.zzb(hashMap, "cs", zzqi2.getSource());
            zzb.zzb(hashMap, "cm", zzqi2.zzzU());
            zzb.zzb(hashMap, "ck", zzqi2.zzzV());
            zzb.zzb(hashMap, "cc", zzqi2.getContent());
            zzb.zzb(hashMap, "ci", zzqi2.getId());
            zzb.zzb(hashMap, "anid", zzqi2.zzzW());
            zzb.zzb(hashMap, "gclid", zzqi2.zzzX());
            zzb.zzb(hashMap, "dclid", zzqi2.zzzY());
            zzb.zzb(hashMap, "aclid", zzqi2.zzzZ());
        }
        if ((zzqm2 = zzc2.zzd(zzqm.class)) != null) {
            zzb.zzb(hashMap, "exd", zzqm2.getDescription());
            zzb.zza(hashMap, "exf", zzqm2.zzAk());
        }
        if ((zzqo2 = zzc2.zzd(zzqo.class)) != null) {
            zzb.zzb(hashMap, "sn", zzqo2.zzAq());
            zzb.zzb(hashMap, "sa", zzqo2.getAction());
            zzb.zzb(hashMap, "st", zzqo2.getTarget());
        }
        if ((zzqp2 = zzc2.zzd(zzqp.class)) != null) {
            zzb.zzb(hashMap, "utv", zzqp2.zzAr());
            zzb.zza(hashMap, "utt", zzqp2.getTimeInMillis());
            zzb.zzb(hashMap, "utc", zzqp2.zzAj());
            zzb.zzb(hashMap, "utl", zzqp2.getLabel());
        }
        if ((zzjz2 = zzc2.zzd(zzjz.class)) != null) {
            object4 = zzjz2.zzix();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzU((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzc2.zzd(zzka.class)) != null) {
            object3 = ((zzka)object4).zziy();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzW((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzc2.zzd(zzqk.class)) != null) {
            object2 = ((zzqk)object3).zzAf();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzqk)object3).zzAi()) {
                hashMap.putAll(promotion.zzaX(com.google.android.gms.analytics.zzc.zzaa(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzqk)object3).zzAg()) {
                hashMap.putAll(product.zzaX(com.google.android.gms.analytics.zzc.zzY(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzqk)object3).zzAh().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzad(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaX(string + com.google.android.gms.analytics.zzc.zzab(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzc2.zzd(zzqj.class)) != null) {
            zzb.zzb(hashMap, "ul", ((zzqj)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzqj)object2).zzAa());
            zzb.zza(hashMap, "sr", ((zzqj)object2).zzAb(), ((zzqj)object2).zzAc());
            zzb.zza(hashMap, "vp", ((zzqj)object2).zzAd(), ((zzqj)object2).zzAe());
        }
        if ((zzqh2 = zzc2.zzd(zzqh.class)) != null) {
            zzb.zzb(hashMap, "an", zzqh2.zzkP());
            zzb.zzb(hashMap, "aid", zzqh2.zzwg());
            zzb.zzb(hashMap, "aiid", zzqh2.zzzT());
            zzb.zzb(hashMap, "av", zzqh2.zzkR());
        }
        return hashMap;
    }

    private static void zzb(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zzb(double d) {
        if (zzNA == null) {
            zzNA = new DecimalFormat("0.######");
        }
        return zzNA.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzA(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzh(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zzb(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

