/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzPa;
    private final Tracker zzPb;
    private final Context mContext;
    private ExceptionParser zzPc;
    private GoogleAnalytics zzPd;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzPa = originalHandler;
        this.zzPb = tracker;
        this.zzPc = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.v("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzPc;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzPc = exceptionParser;
    }

    GoogleAnalytics zziC() {
        if (this.zzPd == null) {
            this.zzPd = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzPd;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzPc != null) {
            object = t != null ? t.getName() : null;
            string = this.zzPc.getDescription((String)object, e);
        }
        zzae.v("Reporting uncaught exception: " + string);
        this.zzPb.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zziC();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zziG();
        if (this.zzPa != null) {
            zzae.v("Passing exception to the original handler");
            this.zzPa.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zziD() {
        return this.zzPa;
    }
}

