/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpq;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzPs;
    private final Map<String, String> zzxA = new HashMap<String, String>();
    private final Map<String, String> zzPt = new HashMap<String, String>();
    private final zzad zzPu;
    private final zza zzPv;
    private ExceptionReporter zzPw;
    private zzal zzPx;

    Tracker(zzf analytics, String trackingId, zzad rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzxA.put("&tid", trackingId);
        }
        this.zzxA.put("useSecure", "1");
        this.zzxA.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzPu = rateLimiter == null ? new zzad("tracking", this.zzjl()) : rateLimiter;
        this.zzPv = new zza(analytics);
    }

    @Override
    protected void zziJ() {
        String string;
        this.zzPv.zza();
        String string2 = this.zziI().zzlg();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zziI().zzli()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzal zzal2) {
        String string;
        this.zzbd("Loading Tracker config values");
        this.zzPx = zzal2;
        if (this.zzPx.zzlT()) {
            string = this.zzPx.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzPx.zzlU()) {
            string = Double.toString(this.zzPx.zzlV());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzPx.zzlW()) {
            int n = this.zzPx.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzPx.zzlX()) {
            boolean bl = this.zzPx.zzlY();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzPx.zzlZ()) {
            boolean bl = this.zzPx.zzma();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzPx.zzmb());
    }

    private boolean zziK() {
        return this.zzPw != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zziK() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzPw = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzPw);
                this.zzbd("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzPw.zziD();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzbd("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzPv.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzPv.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzx.zzz(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzx.zzz(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zzjl().currentTimeMillis();
        if (this.zziC().getAppOptOut()) {
            this.zzbe("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zziC().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzxA, hashMap);
        Tracker.zzb(params, hashMap);
        final boolean bl2 = zzam.zzh(this.zzxA.get("useSecure"), true);
        Tracker.zzc(this.zzPt, hashMap);
        this.zzPt.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzjm().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzjm().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zziL();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzxA.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzxA.put("&a", Integer.toString(n));
            }
        }
        this.zzjo().zzf(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzPv.zziM()) {
                    hashMap.put("sc", "start");
                }
                zzam.zzd(hashMap, "cid", Tracker.this.zziC().getClientId());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzam.zza(d = zzam.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzjs();
                if (bl3) {
                    zzam.zzb(hashMap, "ate", zza2.zziU());
                    zzam.zzc(hashMap, "adid", zza2.zziY());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzpq zzpq2 = Tracker.this.zzjt().zzjS();
                zzam.zzc(hashMap, "an", zzpq2.zzlg());
                zzam.zzc(hashMap, "av", zzpq2.zzli());
                zzam.zzc(hashMap, "aid", zzpq2.zzwK());
                zzam.zzc(hashMap, "aiid", zzpq2.zzAJ());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzQm);
                zzam.zzc(hashMap, "ul", Tracker.this.zzju().zzkZ().getLanguage());
                zzam.zzc(hashMap, "sr", Tracker.this.zzju().zzla());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzPu.zzlw()) {
                    Tracker.this.zzjm().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzam.zzbt((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzjm().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzam.zza(hashMap2, "uid", hashMap);
                zzam.zza(hashMap2, "an", hashMap);
                zzam.zza(hashMap2, "aid", hashMap);
                zzam.zza(hashMap2, "av", hashMap);
                zzam.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zziH().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zziH().zza(zzab3);
            }
        });
    }

    public String get(String key) {
        this.zzjv();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzxA.containsKey(key)) {
            return this.zzxA.get(key);
        }
        if (key.equals("&ul")) {
            return zzam.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zzjr().zzkk();
        }
        if (key.equals("&sr")) {
            return this.zzju().zzla();
        }
        if (key.equals("&aid")) {
            return this.zzjt().zzjS().zzwK();
        }
        if (key.equals("&an")) {
            return this.zzjt().zzjS().zzlg();
        }
        if (key.equals("&av")) {
            return this.zzjt().zzjS().zzli();
        }
        if (key.equals("&aiid")) {
            return this.zzjt().zzjS().zzAJ();
        }
        return null;
    }

    public void set(String key, String value) {
        zzx.zzb((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzxA.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzam.zzK(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzbg("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzam.zzK(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzPt.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("anid")) != null) {
            this.zzPt.put("&anid", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzPt.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzPt.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzPt.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzPt.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzPt.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzPt.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzPt.put("&gclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("aclid")) != null) {
            this.zzPt.put("&aclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzPs = enabled;
    }

    boolean zziL() {
        return this.zzPs;
    }

    static String zzn(Activity activity) {
        zzx.zzz((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzPG;
        private int zzPH;
        private long zzPI;
        private boolean zzPJ;
        private long zzPK;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzPI = -1L;
        }

        @Override
        protected void zziJ() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzPI = sessionTimeout;
            this.zziN();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzPG = enabled;
            this.zziN();
        }

        public synchronized boolean zziM() {
            boolean bl = this.zzPJ;
            this.zzPJ = false;
            return bl;
        }

        private void zziN() {
            if (this.zzPI >= 0L || this.zzPG) {
                this.zziC().zza(Tracker.this.zzPv);
            } else {
                this.zziC().zzb(Tracker.this.zzPv);
            }
        }

        @Override
        public void zzl(Activity activity) {
            if (this.zzPH == 0 && this.zziO()) {
                this.zzPJ = true;
            }
            ++this.zzPH;
            if (this.zzPG) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzPx != null ? Tracker.this.zzPx.zzo(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzn(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzm(Activity activity) {
            --this.zzPH;
            this.zzPH = Math.max(0, this.zzPH);
            if (this.zzPH == 0) {
                this.zzPK = this.zzjl().elapsedRealtime();
            }
        }

        boolean zziO() {
            return this.zzjl().elapsedRealtime() >= this.zzPK + Math.max(1000L, this.zzPI);
        }
    }
}

