/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzn
extends zzd {
    private volatile String zzPO;
    private Future<String> zzRr;

    protected zzn(zzf zzf2) {
        super(zzf2);
    }

    @Override
    protected void zziJ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzkk() {
        this.zzjv();
        zzn zzn2 = this;
        synchronized (zzn2) {
            if (this.zzPO == null) {
                this.zzRr = this.zzjo().zzc(new Callable<String>(){

                    public String zzkp() throws Exception {
                        return zzn.this.zzkm();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzkp();
                    }
                });
            }
            if (this.zzRr != null) {
                try {
                    this.zzPO = this.zzRr.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzPO = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzPO = "0";
                }
                if (this.zzPO == null) {
                    this.zzPO = "0";
                }
                this.zza("Loaded clientId", this.zzPO);
                this.zzRr = null;
            }
            return this.zzPO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzkl() {
        zzn zzn2 = this;
        synchronized (zzn2) {
            this.zzPO = null;
            this.zzRr = this.zzjo().zzc(new Callable<String>(){

                public String zzkp() throws Exception {
                    return zzn.this.zzkn();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzkp();
                }
            });
        }
        return this.zzkk();
    }

    String zzkm() {
        String string = this.zzac(this.zzjo().getContext());
        if (string == null) {
            string = this.zzkn();
        }
        return string;
    }

    private String zzkn() {
        String string = this.zzko();
        try {
            if (!this.zzh(this.zzjo().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzko() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzac(Context context) {
        zzx.zzcE((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                this.zzbg("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            if (n < 14) {
                this.zzbg("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string = null;
                return string;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            String string = null;
            return string;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzh(Context context, String string) {
        zzx.zzcM((String)string);
        zzx.zzcE((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

