/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzbhM;
    private final DataLayer zzbhN;
    private zzcp zzbhO;
    private Map<String, FunctionCallMacroCallback> zzbhP = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzbhQ = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzbhR;
    private volatile String zzbhS = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzrs.zzc resource) {
        this.mContext = context;
        this.zzbhN = dataLayer;
        this.zzbhM = containerId;
        this.zzbhR = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzaf.zzj resource) {
        this.mContext = context;
        this.zzbhN = dataLayer;
        this.zzbhM = containerId;
        this.zzbhR = lastRefreshTime;
        this.zza(resource.zzju);
        if (resource.zzjt != null) {
            this.zza(resource.zzjt);
        }
    }

    public String getContainerId() {
        return this.zzbhM;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzGc();
        if (zzcp2 == null) {
            zzbg.e("getBoolean called for closed container.");
            return zzdf.zzHC();
        }
        try {
            return zzdf.zzk(zzcp2.zzgn(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzHC();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzGc();
        if (zzcp2 == null) {
            zzbg.e("getDouble called for closed container.");
            return zzdf.zzHB();
        }
        try {
            return zzdf.zzj(zzcp2.zzgn(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzHB();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzGc();
        if (zzcp2 == null) {
            zzbg.e("getLong called for closed container.");
            return zzdf.zzHA();
        }
        try {
            return zzdf.zzi(zzcp2.zzgn(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzHA();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzGc();
        if (zzcp2 == null) {
            zzbg.e("getString called for closed container.");
            return zzdf.zzHE();
        }
        try {
            return zzdf.zzg(zzcp2.zzgn(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzHE();
        }
    }

    public long getLastRefreshTime() {
        return this.zzbhR;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzbhP;
        synchronized (map) {
            this.zzbhP.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzbhP;
        synchronized (map) {
            this.zzbhP.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzfP(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzbhP;
        synchronized (map) {
            return this.zzbhP.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzbhQ;
        synchronized (map) {
            this.zzbhQ.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzbhQ;
        synchronized (map) {
            this.zzbhQ.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionCallTagCallback zzfQ(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzbhQ;
        synchronized (map) {
            return this.zzbhQ.get(string);
        }
    }

    public void zzfR(String string) {
        this.zzGc().zzfR(string);
    }

    public String zzGb() {
        return this.zzbhS;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzrs.zzc zzc2 = null;
        try {
            zzc2 = zzrs.zzb(zzf2);
        }
        catch (zzrs.zzg zzg2) {
            zzbg.e("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzGc().zzF(arrayList);
    }

    private void zza(zzrs.zzc zzc2) {
        this.zzbhS = zzc2.getVersion();
        zzah zzah2 = this.zzfS(this.zzbhS);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzbhN, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzbhN.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzbhM));
        }
    }

    zzah zzfS(String string) {
        if (zzcb.zzGU().zzGV().equals((Object)zzcb.zza.zzbjW)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzbhO = zzcp2;
    }

    private synchronized zzcp zzGc() {
        return this.zzbhO;
    }

    void release() {
        this.zzbhO = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzfQ(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzHE();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzfP(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

