/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.os.Process;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.tagmanager.zzbg;
import java.io.IOException;

public class zza {
    private volatile long zzbht = 900000L;
    private volatile long zzbhu = 30000L;
    private volatile boolean mClosed = false;
    private volatile AdvertisingIdClient.Info zzPW;
    private volatile long zzbhv;
    private volatile long zzbhw;
    private final Context mContext;
    private final zzmq zzqW;
    private final Thread zzLM;
    private final Object zzbhx = new Object();
    private zza zzbhy = new zza(){

        @Override
        public AdvertisingIdClient.Info zzFV() {
            AdvertisingIdClient.Info info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)zza.this.mContext);
            }
            catch (IllegalStateException illegalStateException) {
                zzbg.zzd("IllegalStateException getting Advertising Id Info", illegalStateException);
            }
            catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                zzbg.zzd("GooglePlayServicesRepairableException getting Advertising Id Info", googlePlayServicesRepairableException);
            }
            catch (IOException iOException) {
                zzbg.zzd("IOException getting Ad Id Info", iOException);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                zzbg.zzd("GooglePlayServicesNotAvailableException getting Advertising Id Info", googlePlayServicesNotAvailableException);
            }
            catch (Exception exception) {
                zzbg.zzd("Unknown exception. Could not get the Advertising Id Info.", exception);
            }
            return info;
        }
    };
    private static Object zzbhz = new Object();
    private static zza zzbhA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zza zzaW(Context context) {
        if (zzbhA == null) {
            Object object = zzbhz;
            synchronized (object) {
                if (zzbhA == null) {
                    zzbhA = new zza(context);
                    zzbhA.start();
                }
            }
        }
        return zzbhA;
    }

    private zza(Context context) {
        this(context, null, zzmt.zzsc());
    }

    public zza(Context context, zza zza2, zzmq zzmq2) {
        this.zzqW = zzmq2;
        this.mContext = context != null ? context.getApplicationContext() : context;
        if (zza2 != null) {
            this.zzbhy = zza2;
        }
        this.zzbhv = this.zzqW.currentTimeMillis();
        this.zzLM = new Thread(new Runnable(){

            @Override
            public void run() {
                zza.this.zzFU();
            }
        });
    }

    public String zzFQ() {
        if (this.zzPW == null) {
            this.zzFR();
        } else {
            this.zzFS();
        }
        this.zzFT();
        return this.zzPW == null ? null : this.zzPW.getId();
    }

    public boolean isLimitAdTrackingEnabled() {
        if (this.zzPW == null) {
            this.zzFR();
        } else {
            this.zzFS();
        }
        this.zzFT();
        return this.zzPW == null ? true : this.zzPW.isLimitAdTrackingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzFR() {
        zza zza2 = this;
        synchronized (zza2) {
            try {
                this.zzFS();
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzFS() {
        if (this.zzqW.currentTimeMillis() - this.zzbhv > this.zzbhu) {
            Object object = this.zzbhx;
            synchronized (object) {
                this.zzbhx.notify();
            }
            this.zzbhv = this.zzqW.currentTimeMillis();
        }
    }

    private void zzFT() {
        if (this.zzqW.currentTimeMillis() - this.zzbhw > 3600000L) {
            this.zzPW = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzFU() {
        Process.setThreadPriority((int)10);
        while (!this.mClosed) {
            AdvertisingIdClient.Info info = this.zzbhy.zzFV();
            if (info != null) {
                this.zzPW = info;
                this.zzbhw = this.zzqW.currentTimeMillis();
                zzbg.zzaJ("Obtained fresh AdvertisingId info from GmsCore.");
            }
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            try {
                object = this.zzbhx;
                synchronized (object) {
                    this.zzbhx.wait(this.zzbht);
                }
            }
            catch (InterruptedException interruptedException) {
                zzbg.zzaJ("sleep interrupted in AdvertiserDataPoller thread; continuing");
            }
        }
    }

    public void start() {
        this.zzLM.start();
    }

    public static interface zza {
        public AdvertisingIdClient.Info zzFV();
    }
}

