/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzrq;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcn
implements zzp.zzf {
    private final Context mContext;
    private final String zzbhM;
    private final ExecutorService zzbkn;
    private zzbf<zzrq.zza> zzbkg;

    zzcn(Context context, String string) {
        this.mContext = context;
        this.zzbhM = string;
        this.zzbkn = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbf<zzrq.zza> zzbf2) {
        this.zzbkg = zzbf2;
    }

    @Override
    public void zzGl() {
        this.zzbkn.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzHc();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzHc() {
        if (this.zzbkg == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.zzbkg.zzGk();
        zzbg.v("Attempting to load resource from disk");
        if ((zzcb.zzGU().zzGV() == zzcb.zza.zzbjV || zzcb.zzGU().zzGV() == zzcb.zza.zzbjW) && this.zzbhM.equals(zzcb.zzGU().getContainerId())) {
            this.zzbkg.zza(zzbf.zza.zzbju);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzHd());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.zzaI("Failed to find the resource in the disk");
            this.zzbkg.zza(zzbf.zza.zzbju);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzrs.zzb(fileInputStream, byteArrayOutputStream);
            zzrq.zza zza2 = zzrq.zza.zzy(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.zzbkg.zzI(zza2);
        }
        catch (IOException iOException) {
            this.zzbkg.zza(zzbf.zza.zzbjv);
            zzbg.zzaK("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzbkg.zza(zzbf.zza.zzbjv);
            zzbg.zzaK("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaK("Error closing stream for reading resource from disk");
            }
        }
        zzbg.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzrq.zza zza2) {
        this.zzbkn.execute(new Runnable(){

            @Override
            public void run() {
                zzcn.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzrs.zzc zzke(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.zzaK("Failed to load the container. No default container resource found with the resource ID " + n);
            return null;
        }
        zzbg.v("Attempting to load a container from the resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzrs.zzb(inputStream, byteArrayOutputStream);
            zzrs.zzc zzc2 = this.zza(byteArrayOutputStream);
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzx(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            zzbg.zzaK("Error reading the default container with resource ID " + n + " (" + this.mContext.getResources().getResourceName(n) + ")");
            return null;
        }
    }

    private zzrs.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzaz.zzgi(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbg.zzaI("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbg.zzaK("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzrs.zzc zzx(byte[] byArray) {
        try {
            zzrs.zzc zzc2 = zzrs.zzb(zzaf.zzf.zzc(byArray));
            if (zzc2 != null) {
                zzbg.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzst zzst2) {
            zzbg.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzrs.zzg zzg2) {
            zzbg.zzaK("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.zzbkn.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzrq.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzHd();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzsu.toByteArray((zzsu)zza2));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            zzbg.zzaK("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaK("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzHd() {
        String string = "resource_" + this.zzbhM;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void zzd(zzrq.zza zza2) throws IllegalArgumentException {
        if (zza2.zzju == null && zza2.zzbme == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

