/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.tagmanager.zzac;
import com.google.android.gms.tagmanager.zzaq;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;

class zzcx
implements zzac {
    private final String zzzN;
    private final Context mContext;
    private final zzb zzblh;
    private final zza zzbli;

    zzcx(zzb zzb2, Context context, zza zza2) {
        this.zzblh = zzb2;
        this.mContext = context.getApplicationContext();
        this.zzbli = zza2;
        this.zzzN = this.zza("GoogleTagManager", "4.00", Build.VERSION.RELEASE, zzcx.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
    }

    zzcx(Context context, zza zza2) {
        this(new zzb(){

            @Override
            public HttpURLConnection zzd(URL uRL) throws IOException {
                return (HttpURLConnection)uRL.openConnection();
            }
        }, context, zza2);
    }

    @Override
    public boolean zzGw() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzE(List<zzaq> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            zzaq zzaq2 = list.get(i);
            URL uRL = this.zzd(zzaq2);
            if (uRL == null) {
                zzbg.zzaK("No destination: discarding hit.");
                this.zzbli.zzb(zzaq2);
                continue;
            }
            HttpURLConnection httpURLConnection = null;
            try {
                httpURLConnection = this.zzblh.zzd(uRL);
                try {
                    if (bl) {
                        zzbl.zzbb(this.mContext);
                        bl = false;
                    }
                    httpURLConnection.setRequestProperty("User-Agent", this.zzzN);
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 != 200) {
                        zzbg.zzaK("Bad response: " + n2);
                        this.zzbli.zzc(zzaq2);
                        continue;
                    }
                    this.zzbli.zza(zzaq2);
                    continue;
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                zzbg.zzaK("Exception sending hit: " + iOException.getClass().getSimpleName());
                zzbg.zzaK(iOException.getMessage());
                this.zzbli.zzc(zzaq2);
            }
        }
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzaq zzaq2) {
        String string = zzaq2.zzGF();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            zzbg.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    static interface zzb {
        public HttpURLConnection zzd(URL var1) throws IOException;
    }

    public static interface zza {
        public void zza(zzaq var1);

        public void zzb(zzaq var1);

        public void zzc(zzaq var1);
    }
}

