/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzrp;

public final class AnalyticsService
extends Service {
    private final Handler mHandler = new Handler();
    private static Boolean zzOO;

    public static boolean zzZ(Context context) {
        zzx.zzz((Object)context);
        if (zzOO != null) {
            return zzOO;
        }
        boolean bl = zzam.zza(context, AnalyticsService.class);
        zzOO = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        super.onCreate();
        zzf zzf2 = zzf.zzaa((Context)this);
        zzaf zzaf2 = zzf2.zzjm();
        if (zzf2.zzjn().zzkr()) {
            zzaf2.zzbd("Device AnalyticsService is starting up");
        } else {
            zzaf2.zzbd("Local AnalyticsService is starting up");
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzf zzf2 = zzf.zzaa((Context)this);
        zzaf zzaf2 = zzf2.zzjm();
        if (zzf2.zzjn().zzkr()) {
            zzaf2.zzbd("Device AnalyticsService is shutting down");
        } else {
            zzaf2.zzbd("Local AnalyticsService is shutting down");
        }
        super.onDestroy();
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int flags, final int startId) {
        this.zziz();
        final zzf zzf2 = zzf.zzaa((Context)this);
        final zzaf zzaf2 = zzf2.zzjm();
        String string = intent.getAction();
        if (zzf2.zzjn().zzkr()) {
            zzaf2.zza("Device AnalyticsService called. startId, action", startId, string);
        } else {
            zzaf2.zza("Local AnalyticsService called. startId, action", startId, string);
        }
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            zzf2.zziH().zza(new zzw(){

                @Override
                public void zzc(Throwable throwable) {
                    AnalyticsService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = AnalyticsService.this.stopSelfResult(startId);
                            if (bl) {
                                if (zzf2.zzjn().zzkr()) {
                                    zzaf2.zzbd("Device AnalyticsService processed last dispatch request");
                                } else {
                                    zzaf2.zzbd("Local AnalyticsService processed last dispatch request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zziz() {
        try {
            Object object = AnalyticsReceiver.zzqy;
            synchronized (object) {
                zzrp zzrp2 = AnalyticsReceiver.zzOM;
                if (zzrp2 != null && zzrp2.isHeld()) {
                    zzrp2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

