/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.os.Bundle;
import com.google.android.gms.appindexing.Thing;
import com.google.android.gms.common.internal.zzx;

public final class Action
extends Thing {
    public static final String TYPE_ADD = "http://schema.org/AddAction";
    public static final String TYPE_BOOKMARK = "http://schema.org/BookmarkAction";
    public static final String TYPE_LIKE = "http://schema.org/LikeAction";
    public static final String TYPE_LISTEN = "http://schema.org/ListenAction";
    public static final String TYPE_VIEW = "http://schema.org/ViewAction";
    public static final String TYPE_WANT = "http://schema.org/WantAction";
    public static final String TYPE_WATCH = "http://schema.org/WatchAction";
    public static final String STATUS_TYPE_ACTIVE = "http://schema.org/ActiveActionStatus";
    public static final String STATUS_TYPE_COMPLETED = "http://schema.org/CompletedActionStatus";
    public static final String STATUS_TYPE_FAILED = "http://schema.org/FailedActionStatus";

    private Action(Bundle propertyBundle) {
        super(propertyBundle);
    }

    public static Action newAction(String actionType, String objectName, Uri objectId, Uri objectAppUri) {
        return new Builder(actionType).setObject(new Thing.Builder().setName(objectName).setId(objectId == null ? null : objectId.toString()).setUrl(objectAppUri).build()).build();
    }

    public static Action newAction(String actionType, String objectName, Uri objectAppUri) {
        return Action.newAction(actionType, objectName, null, objectAppUri);
    }

    public static final class Builder
    extends Thing.Builder {
        public Builder(String actionType) {
            zzx.zzl((Object)actionType);
            super.put("type", actionType);
        }

        @Override
        public Builder setName(String name) {
            return (Builder)super.put("name", name);
        }

        @Override
        public Builder setUrl(Uri url) {
            if (url != null) {
                super.put("url", url.toString());
            }
            return this;
        }

        @Override
        public Builder put(String key, String value) {
            return (Builder)super.put(key, value);
        }

        @Override
        public Builder put(String key, Thing value) {
            return (Builder)super.put(key, value);
        }

        public Builder setObject(Thing thing) {
            zzx.zzl((Object)thing);
            return (Builder)super.put("object", thing);
        }

        public Builder setActionStatus(String actionStatusType) {
            zzx.zzl((Object)actionStatusType);
            return (Builder)super.put("actionStatus", actionStatusType);
        }

        @Override
        public Action build() {
            zzx.zzb((Object)this.zzGK.get("object"), (Object)"setObject is required before calling build().");
            zzx.zzb((Object)this.zzGK.get("type"), (Object)"setType is required before calling build().");
            Bundle bundle = (Bundle)this.zzGK.getParcelable("object");
            zzx.zzb((Object)bundle.get("name"), (Object)"Must call setObject() with a valid name. Example: setObject(new Thing.Builder().setName(name).setUrl(url))");
            zzx.zzb((Object)bundle.get("url"), (Object)"Must call setObject() with a valid app URI. Example: setObject(new Thing.Builder().setName(name).setUrl(url))");
            return new Action(this.zzGK);
        }
    }
}

