/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import java.util.List;

public final class zzjj
implements AppIndexApi,
zzjd {
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final zzjb ... zzjbArray) {
        final String string = googleApiClient.getContext().getPackageName();
        return googleApiClient.zza((zza.zza)new zzc<Status>(googleApiClient){

            @Override
            protected void zza(zzje zzje2) throws RemoteException {
                zzje2.zza((zzjf)new zzd((zza.zzb<Status>)this), string, zzjbArray);
            }
        });
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Intent viewIntent, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzjj.zze(outLinks);
        return this.zza(apiClient, new zzjb(string, viewIntent, title, webUrl, null, outLinks));
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Intent viewIntent) {
        String string = apiClient.getContext().getPackageName();
        zzjb zzjb2 = new zzjb(zzjb.zza(string, viewIntent), System.currentTimeMillis(), 3);
        return this.zza(apiClient, zzjb2);
    }

    public static Intent zza(String string, Uri uri) {
        zzjj.zzb(string, uri);
        List list = uri.getPathSegments();
        String string2 = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string2);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return new Intent("android.intent.action.VIEW", builder.build());
    }

    private static void zzb(String string, Uri uri) {
        String string2 = uri.getScheme();
        if (!"android-app".equals(string2)) {
            throw new IllegalArgumentException("AppIndex: The URI scheme must be 'android-app' and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        String string3 = uri.getHost();
        if (string != null && !string.equals(string3)) {
            throw new IllegalArgumentException("AppIndex: The URI host must match the package name and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        List list = uri.getPathSegments();
        if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
            throw new IllegalArgumentException("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
    }

    public static void zze(List<AppIndexApi.AppIndexingLink> list) {
        if (list == null) {
            return;
        }
        for (AppIndexApi.AppIndexingLink appIndexingLink : list) {
            zzjj.zzb(null, appIndexingLink.appIndexingUrl);
        }
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Uri appIndexingUrl, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzjj.zzb(string, appIndexingUrl);
        Intent intent = zzjj.zza(string, appIndexingUrl);
        return this.view(apiClient, activity, intent, title, webUrl, outLinks);
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Uri appUri) {
        String string = apiClient.getContext().getPackageName();
        Intent intent = zzjj.zza(string, appUri);
        return this.viewEnd(apiClient, activity, intent);
    }

    @Override
    public AppIndexApi.ActionResult action(GoogleApiClient apiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(apiClient, action, 0);
        return new zza(this, pendingResult, action);
    }

    @Override
    public PendingResult<Status> start(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 0);
    }

    @Override
    public PendingResult<Status> end(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 3);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        zzjb zzjb2 = zzji.zza(action, l, string, n);
        return this.zza(googleApiClient, zzjb2);
    }

    @Deprecated
    private static final class zza
    implements AppIndexApi.ActionResult {
        private zzjj zzGG;
        private PendingResult<Status> zzGH;
        private Action zzGI;

        zza(zzjj zzjj2, PendingResult<Status> pendingResult, Action action) {
            this.zzGG = zzjj2;
            this.zzGH = pendingResult;
            this.zzGI = action;
        }

        @Override
        public PendingResult<Status> end(GoogleApiClient apiClient) {
            String string = apiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            zzjb zzjb2 = zzji.zza(this.zzGI, l, string, 3);
            return this.zzGG.zza(apiClient, zzjb2);
        }

        @Override
        public PendingResult<Status> getPendingResult() {
            return this.zzGH;
        }
    }

    private static final class zzd
    extends zzjg<Status> {
        public zzd(zza.zzb<Status> zzb2) {
            super(zzb2);
        }

        @Override
        public void zza(Status status) {
            this.zzGC.zzd((Object)status);
        }
    }

    private static abstract class zzc<T extends Result>
    extends zzb<Status> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb<T extends Result>
    extends zza.zza<T, zzjh> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzim.zzFC, googleApiClient);
        }

        protected final void zza(zzjh zzjh2) throws RemoteException {
            this.zza(zzjh2.zzgY());
        }

        protected abstract void zza(zzje var1) throws RemoteException;
    }
}

