/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.zzac;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzg;
import java.util.Arrays;

public abstract class IndexableBuilder<T extends IndexableBuilder<?>> {
    final Bundle eY;
    final String zzcln;
    Thing.Metadata aTk;
    String zzae;

    protected IndexableBuilder(@NonNull String string) {
        zzac.zzy((Object)string);
        zzac.zzhz((String)string);
        this.eY = new Bundle();
        this.zzcln = string;
    }

    @KeepName
    public T put(@NonNull String string, String ... stringArray) {
        zzac.zzy((Object)string);
        zzac.zzy((Object)stringArray);
        if (stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < Math.min(stringArray.length, 100); ++i) {
                int n2;
                stringArray[n] = stringArray[i];
                if (stringArray[i] == null) {
                    n2 = i;
                    zzg.zzrs(new StringBuilder(59).append("String at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                if (stringArray[n].length() > 20000) {
                    n2 = i;
                    zzg.zzrs(new StringBuilder(53).append("String at ").append(n2).append(" is too long, truncating string.").toString());
                    stringArray[n] = stringArray[n].substring(0, 20000);
                }
                ++n;
            }
            if (n > 0) {
                stringArray = Arrays.copyOfRange(stringArray, 0, n);
                this.eY.putStringArray(string, IndexableBuilder.zzd(stringArray));
            }
        } else {
            zzg.zzrs("String array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        zzac.zzy((Object)string);
        zzac.zzy((Object)indexableArray);
        Thing[] thingArray = new Thing[indexableArray.length];
        for (int i = 0; i < indexableArray.length; ++i) {
            if (indexableArray[i] != null && !(indexableArray[i] instanceof Thing)) {
                throw new FirebaseAppIndexingInvalidArgumentException("Invalid Indexable encountered. Use Indexable.Builder or convenience methods under Indexables to create the Indexable.");
            }
            thingArray[i] = (Thing)indexableArray[i];
        }
        this.zza(string, thingArray);
        return this.zzcoa();
    }

    private T zza(@NonNull String string, Thing ... thingArray) {
        zzac.zzy((Object)string);
        zzac.zzy((Object)thingArray);
        if (thingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[n] = thingArray[i];
                if (thingArray[i] == null) {
                    int n2 = i;
                    zzg.zzrs(new StringBuilder(58).append("Thing at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                thingArray = Arrays.copyOfRange(thingArray, 0, n);
                this.eY.putParcelableArray(string, (Parcelable[])IndexableBuilder.zzd(thingArray));
            }
        } else {
            zzg.zzrs("Thing array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, boolean ... blArray) {
        zzac.zzy((Object)string);
        zzac.zzy((Object)blArray);
        if (blArray.length > 0) {
            this.eY.putBooleanArray(string, IndexableBuilder.zza(blArray));
        } else {
            zzg.zzrs("Boolean array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, long ... lArray) {
        zzac.zzy((Object)string);
        zzac.zzy((Object)lArray);
        if (lArray.length > 0) {
            this.eY.putLongArray(string, IndexableBuilder.zzb(lArray));
        } else {
            zzg.zzrs("Long array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public final T setName(@NonNull String string) {
        zzac.zzy((Object)string);
        return this.put("name", string);
    }

    @KeepName
    public final T setUrl(@NonNull String string) {
        zzac.zzy((Object)string);
        this.zzae = string;
        return this.zzcoa();
    }

    @KeepName
    public final T setImage(@NonNull String string) {
        zzac.zzy((Object)string);
        return this.put("image", string);
    }

    @KeepName
    public final T setDescription(@NonNull String string) {
        zzac.zzy((Object)string);
        return this.put("description", string);
    }

    @KeepName
    public final T setSameAs(@NonNull String string) {
        zzac.zzy((Object)string);
        return this.put("sameAs", string);
    }

    @KeepName
    public T setMetadata(@NonNull Indexable.Metadata.Builder builder) {
        zzac.zza((this.aTk == null ? 1 : 0) != 0, (Object)"setMetadata may only be called once");
        zzac.zzy((Object)builder);
        this.aTk = builder.zzcnz();
        return this.zzcoa();
    }

    @KeepName
    public final Indexable build() {
        return new Thing(new Bundle(this.eY), this.aTk == null ? Indexable.Metadata.aTg : this.aTk, this.zzae, this.zzcln);
    }

    protected <S extends IndexableBuilder> T put(@NonNull String string, S ... SArray) {
        zzac.zzy((Object)string);
        zzac.zzy(SArray);
        if (SArray.length > 0) {
            Thing[] thingArray = new Thing[SArray.length];
            for (int i = 0; i < SArray.length; ++i) {
                if (SArray[i] == null) {
                    int n = i;
                    zzg.zzrs(new StringBuilder(60).append("Builder at ").append(n).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                thingArray[i] = (Thing)((IndexableBuilder)SArray[i]).build();
            }
            if (thingArray.length > 0) {
                this.zza(string, thingArray);
            }
        } else {
            zzg.zzrs("Builder array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    private T zzcoa() {
        return (T)this;
    }

    private static <S> S[] zzd(S[] SArray) {
        if (SArray.length < 100) {
            return SArray;
        }
        zzg.zzrs("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(SArray, 100);
    }

    private static long[] zzb(long[] lArray) {
        if (lArray.length < 100) {
            return lArray;
        }
        zzg.zzrs("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(lArray, 100);
    }

    private static boolean[] zza(boolean[] blArray) {
        if (blArray.length < 100) {
            return blArray;
        }
        zzg.zzrs("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(blArray, 100);
    }
}

