/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.zze;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzac;
import java.io.IOException;
import java.util.List;

public final class GoogleAuthUtil
extends zze {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final String KEY_CALLER_UID = zze.KEY_CALLER_UID;
    public static final String KEY_ANDROID_PACKAGE_NAME = zze.KEY_ANDROID_PACKAGE_NAME;
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;

    @Deprecated
    public static String getTokenWithNotification(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, string2, bundle);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String string, String string2, Bundle bundle, Intent intent) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, string2, bundle, intent);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String string, String string2, Bundle bundle, String string3, Bundle bundle2) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, string2, bundle, string3, bundle2);
    }

    public static String getTokenWithNotification(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zza(context, account, string, bundle);
        return tokenData.getToken();
    }

    public static TokenData zza(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzb(context, account, string, bundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String string, Bundle bundle, Intent intent) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.zzi(intent);
        bundle = bundle == null ? new Bundle() : bundle;
        bundle.putParcelable("callback_intent", (Parcelable)intent);
        bundle.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, string, bundle);
        return tokenData.getToken();
    }

    public static String getTokenWithNotification(Context context, Account account, String string, Bundle bundle, String string2, Bundle bundle2) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        zzac.zzh((String)string2, (Object)"Authority cannot be empty or null.");
        bundle = bundle == null ? new Bundle() : bundle;
        bundle2 = bundle2 == null ? new Bundle() : bundle2;
        ContentResolver.validateSyncExtrasBundle((Bundle)bundle2);
        bundle.putString("authority", string2);
        bundle.putBundle("sync_extras", bundle2);
        bundle.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, string, bundle);
        return tokenData.getToken();
    }

    private static TokenData zzb(Context context, Account account, String string, Bundle bundle) throws IOException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            TokenData tokenData = GoogleAuthUtil.zzc(context, account, string, bundle);
            GooglePlayServicesUtil.zzan((Context)context);
            return tokenData;
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            GooglePlayServicesUtil.showErrorNotification((int)n, (Context)context);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)googlePlayServicesAvailabilityException);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.zzan((Context)context);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)userRecoverableAuthException);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private GoogleAuthUtil() {
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, string, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, string, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, account, string);
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, account, string, bundle);
    }

    public static TokenData zzc(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.zzc(context, account, string, bundle);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        zze.invalidateToken(context, string);
    }

    public static void clearToken(Context context, String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zze.clearToken(context, string);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int n, String string) throws GoogleAuthException, IOException {
        return zze.getAccountChangeEvents(context, n, string);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        return zze.getAccountId(context, string);
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        return zze.removeAccount(context, account);
    }
}

