/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import com.google.android.gms.auth.api.proxy.zza;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@KeepForSdkWithMembers
public class ProxyRequest
extends zzbgl {
    public static final int VERSION_CODE = 2;
    public static final Parcelable.Creator<ProxyRequest> CREATOR = new zza();
    public static final int HTTP_METHOD_GET = 0;
    public static final int HTTP_METHOD_POST = 1;
    public static final int HTTP_METHOD_PUT = 2;
    public static final int HTTP_METHOD_DELETE = 3;
    public static final int HTTP_METHOD_HEAD = 4;
    public static final int HTTP_METHOD_OPTIONS = 5;
    public static final int HTTP_METHOD_TRACE = 6;
    public static final int HTTP_METHOD_PATCH = 7;
    public static final int LAST_CODE = 7;
    private int zza;
    public final String url;
    public final int httpMethod;
    public final long timeoutMillis;
    public final byte[] body;
    private Bundle zzb;

    ProxyRequest(int n, String string, int n2, long l, byte[] byArray, Bundle bundle) {
        this.zza = n;
        this.url = string;
        this.httpMethod = n2;
        this.timeoutMillis = l;
        this.body = byArray;
        this.zzb = bundle;
    }

    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzb.size());
        for (String string : this.zzb.keySet()) {
            linkedHashMap.put(string, this.zzb.getString(string));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        String string = this.url;
        int n = this.httpMethod;
        return new StringBuilder(42 + String.valueOf(string).length()).append("ProxyRequest[ url: ").append(string).append(", method: ").append(n).append(" ]").toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ProxyRequest proxyRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)proxyRequest.url, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)proxyRequest.httpMethod);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)proxyRequest.timeoutMillis);
        zzbgo.zza((Parcel)parcel2, (int)4, (byte[])proxyRequest.body, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Bundle)proxyRequest.zzb, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)1000, (int)proxyRequest.zza);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    @KeepForSdkWithMembers
    public static class Builder {
        private String zza;
        private int zzb = HTTP_METHOD_GET;
        private long zzc = 3000L;
        private byte[] zzd = null;
        private Bundle zze = new Bundle();

        public Builder(String string) {
            zzbq.zza((String)string);
            if (Patterns.WEB_URL.matcher(string).matches()) {
                this.zza = string;
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(string).length()).append("The supplied url [ ").append(string).append("] is not match Patterns.WEB_URL!").toString());
        }

        public Builder setHttpMethod(int n) {
            zzbq.zzb((n >= 0 && n <= LAST_CODE ? 1 : 0) != 0, (Object)"Unrecognized http method code.");
            this.zzb = n;
            return this;
        }

        public Builder setTimeoutMillis(long l) {
            zzbq.zzb((l >= 0L ? 1 : 0) != 0, (Object)"The specified timeout must be non-negative.");
            this.zzc = l;
            return this;
        }

        public Builder putHeader(String string, String string2) {
            zzbq.zza((String)string, (Object)"Header name cannot be null or empty!");
            this.zze.putString(string, string2 == null ? "" : string2);
            return this;
        }

        public Builder setBody(byte[] byArray) {
            this.zzd = byArray;
            return this;
        }

        public ProxyRequest build() {
            if (this.zzd == null) {
                this.zzd = new byte[0];
            }
            return new ProxyRequest(2, this.zza, this.zzb, this.zzc, this.zzd, this.zze);
        }
    }
}

