/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="AccountChangeEventCreator")
public class AccountChangeEvent
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR = new zzd();
    @SafeParcelable.VersionField(id=1)
    private final int zzh;
    @SafeParcelable.Field(id=2)
    private final long zzi;
    @SafeParcelable.Field(id=3)
    private final String zzj;
    @SafeParcelable.Field(id=4)
    private final int zzk;
    @SafeParcelable.Field(id=5)
    private final int zzl;
    @SafeParcelable.Field(id=6)
    private final String zzm;

    @SafeParcelable.Constructor
    AccountChangeEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) String string2) {
        this.zzh = n;
        this.zzi = l;
        this.zzj = (String)Preconditions.checkNotNull((Object)string);
        this.zzk = n2;
        this.zzl = n3;
        this.zzm = string2;
    }

    public AccountChangeEvent(long l, String string, int n, int n2, String string2) {
        this.zzh = 1;
        this.zzi = l;
        this.zzj = (String)Preconditions.checkNotNull((Object)string);
        this.zzk = n;
        this.zzl = n2;
        this.zzm = string2;
    }

    public String getAccountName() {
        return this.zzj;
    }

    public int getChangeType() {
        return this.zzk;
    }

    public int getEventIndex() {
        return this.zzl;
    }

    public String getChangeData() {
        return this.zzm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AccountChangeEvent accountChangeEvent = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)accountChangeEvent.zzh);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)accountChangeEvent.zzi);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)accountChangeEvent.zzj, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)accountChangeEvent.zzk);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)accountChangeEvent.zzl);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)accountChangeEvent.zzm, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = "UNKNOWN";
        switch (this.zzk) {
            case 1: {
                string = "ADDED";
                break;
            }
            case 2: {
                string = "REMOVED";
                break;
            }
            case 4: {
                string = "RENAMED_TO";
                break;
            }
            case 3: {
                string = "RENAMED_FROM";
            }
        }
        String string2 = this.zzj;
        String string3 = string;
        String string4 = this.zzm;
        int n = this.zzl;
        return new StringBuilder(91 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("AccountChangeEvent {accountName = ").append(string2).append(", changeType = ").append(string3).append(", changeData = ").append(string4).append(", eventIndex = ").append(n).append("}").toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AccountChangeEvent) {
            AccountChangeEvent accountChangeEvent = (AccountChangeEvent)((Object)object);
            return this.zzh == accountChangeEvent.zzh && this.zzi == accountChangeEvent.zzi && Objects.equal((Object)this.zzj, (Object)accountChangeEvent.zzj) && this.zzk == accountChangeEvent.zzk && this.zzl == accountChangeEvent.zzl && Objects.equal((Object)this.zzm, (Object)accountChangeEvent.zzm);
        }
        return false;
    }
}

