/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import com.google.android.gms.auth.api.proxy.zzd;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@SafeParcelable.Class(creator="ProxyRequestCreator")
@KeepForSdkWithMembers
public class ProxyRequest
extends AbstractSafeParcelable {
    public static final int VERSION_CODE = 2;
    public static final Parcelable.Creator<ProxyRequest> CREATOR = new zzd();
    public static final int HTTP_METHOD_GET = 0;
    public static final int HTTP_METHOD_POST = 1;
    public static final int HTTP_METHOD_PUT = 2;
    public static final int HTTP_METHOD_DELETE = 3;
    public static final int HTTP_METHOD_HEAD = 4;
    public static final int HTTP_METHOD_OPTIONS = 5;
    public static final int HTTP_METHOD_TRACE = 6;
    public static final int HTTP_METHOD_PATCH = 7;
    public static final int LAST_CODE = 7;
    @SafeParcelable.VersionField(id=1000)
    private final int versionCode;
    @SafeParcelable.Field(id=1)
    public final String url;
    @SafeParcelable.Field(id=2)
    public final int httpMethod;
    @SafeParcelable.Field(id=3)
    public final long timeoutMillis;
    @SafeParcelable.Field(id=4)
    public final byte[] body;
    @SafeParcelable.Field(id=5)
    private Bundle zzdw;

    @SafeParcelable.Constructor
    ProxyRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) byte[] byArray, @SafeParcelable.Param(id=5) Bundle bundle) {
        this.versionCode = n;
        this.url = string;
        this.httpMethod = n2;
        this.timeoutMillis = l;
        this.body = byArray;
        this.zzdw = bundle;
    }

    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzdw.size());
        for (String string : this.zzdw.keySet()) {
            linkedHashMap.put(string, this.zzdw.getString(string));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        String string = this.url;
        int n = this.httpMethod;
        return new StringBuilder(42 + String.valueOf(string).length()).append("ProxyRequest[ url: ").append(string).append(", method: ").append(n).append(" ]").toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ProxyRequest proxyRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)proxyRequest.url, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)proxyRequest.httpMethod);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)proxyRequest.timeoutMillis);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)4, (byte[])proxyRequest.body, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)5, (Bundle)proxyRequest.zzdw, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)proxyRequest.versionCode);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @KeepForSdkWithMembers
    public static class Builder {
        private String zzdx;
        private int zzdy = HTTP_METHOD_GET;
        private long zzdz = 3000L;
        private byte[] zzea = null;
        private Bundle zzeb = new Bundle();

        public Builder(String string) {
            Preconditions.checkNotEmpty((String)string);
            if (Patterns.WEB_URL.matcher(string).matches()) {
                this.zzdx = string;
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(string).length()).append("The supplied url [ ").append(string).append("] is not match Patterns.WEB_URL!").toString());
        }

        public Builder setHttpMethod(int n) {
            Preconditions.checkArgument((n >= 0 && n <= LAST_CODE ? 1 : 0) != 0, (Object)"Unrecognized http method code.");
            this.zzdy = n;
            return this;
        }

        public Builder setTimeoutMillis(long l) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"The specified timeout must be non-negative.");
            this.zzdz = l;
            return this;
        }

        public Builder putHeader(String string, String string2) {
            Preconditions.checkNotEmpty((String)string, (Object)"Header name cannot be null or empty!");
            this.zzeb.putString(string, string2 == null ? "" : string2);
            return this;
        }

        public Builder setBody(byte[] byArray) {
            this.zzea = byArray;
            return this;
        }

        public ProxyRequest build() {
            if (this.zzea == null) {
                this.zzea = new byte[0];
            }
            return new ProxyRequest(2, this.zzdx, this.zzdy, this.zzdz, this.zzea, this.zzeb);
        }
    }
}

