/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzh;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.auth.zzj;
import com.google.android.gms.auth.zzk;
import com.google.android.gms.auth.zzl;
import com.google.android.gms.auth.zzm;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import java.io.IOException;
import java.util.List;

public class zzg {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    private static final String[] ACCEPTABLE_ACCOUNT_TYPES = new String[]{"com.google", "com.google.work", "cn.google"};
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_CALLER_UID = "callerUid";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_ANDROID_PACKAGE_NAME = "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzp = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final Logger zzq;

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzg.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzg.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzg.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzg.zze(account);
        return zzg.zze(context, account, string, bundle).zze();
    }

    public static TokenData zze(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        Preconditions.checkNotEmpty((String)string, (Object)"Scope cannot be empty or null.");
        zzg.zze(account);
        zzg.ensurePlayServicesAvailable(context, 8400000);
        Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zzh zzh2 = new zzh(account, string, bundle2);
        return zzg.zzd(context, zzp, zzh2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzg.ensurePlayServicesAvailable(context, 8400000);
        Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zzi zzi2 = new zzi(string, bundle);
        zzg.zzd(context, zzp, zzi2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int n, String string) throws GoogleAuthException, IOException {
        Preconditions.checkNotEmpty((String)string, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzg.ensurePlayServicesAvailable(context, 8400000);
        zzj zzj2 = new zzj(string, n);
        return zzg.zzd(context, zzp, zzj2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        Preconditions.checkNotEmpty((String)string, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzg.ensurePlayServicesAvailable(context, 8400000);
        return zzg.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        Preconditions.checkNotNull((Object)context);
        zzg.zze(account);
        zzg.ensurePlayServicesAvailable(context, 8400000);
        zzk zzk2 = new zzk(account);
        return zzg.zzd(context, zzp, zzk2);
    }

    @TargetApi(value=26)
    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        Preconditions.checkNotNull((Object)context);
        zzg.ensurePlayServicesAvailable(context, 11400000);
        String string = context.getApplicationInfo().packageName;
        zzl zzl2 = new zzl(string);
        return zzg.zzd(context, zzp, zzl2);
    }

    private static void zze(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)account.name)) {
            throw new IllegalArgumentException("Account name cannot be empty!");
        }
        String[] stringArray = ACCEPTABLE_ACCOUNT_TYPES;
        int n = ACCEPTABLE_ACCOUNT_TYPES.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(account.type)) continue;
            return;
        }
        throw new IllegalArgumentException("Account type not supported");
    }

    private static void ensurePlayServicesAvailable(Context context, int n) throws GoogleAuthException {
        try {
            GooglePlayServicesUtilLight.ensurePlayServicesAvailable((Context)context.getApplicationContext(), (int)n);
            return;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzd(T t) throws IOException {
        if (t == null) {
            zzq.w("GoogleAuthUtil", new Object[]{"Binder call returned null."});
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zzd(Context context, ComponentName componentName, zzm<T> zzm2) throws IOException, GoogleAuthException {
        BlockingServiceConnection blockingServiceConnection = new BlockingServiceConnection();
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance((Context)context);
        if (gmsClientSupervisor.bindService(componentName, (ServiceConnection)blockingServiceConnection, "GoogleAuthUtil")) {
            try {
                T t = zzm2.zze(blockingServiceConnection.getService());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                zzq.i("GoogleAuthUtil", new Object[]{"Error on service connection.", throwable});
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                gmsClientSupervisor.unbindService(componentName, (ServiceConnection)blockingServiceConnection, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zzg() {
    }

    static /* synthetic */ Object zze(Object object) throws IOException {
        return zzg.zzd(object);
    }

    static /* synthetic */ Logger zzd() {
        return zzq;
    }

    static {
        String[] stringArray = new String[]{"GoogleAuthUtil"};
        zzq = new Logger("Auth", stringArray);
    }
}

