/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.zzl;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Preconditions;
import java.io.IOException;
import java.util.List;

public final class GoogleAuthUtil
extends zzl {
    @NonNull
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    @NonNull
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    @NonNull
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=23)
    @NonNull
    public static Bundle removeAccount(@NonNull Context context, @NonNull Account account) throws GoogleAuthException, IOException {
        void var1_1;
        return zzl.removeAccount(context, (Account)var1_1);
    }

    @TargetApi(value=26)
    @NonNull
    public static Boolean requestGoogleAccountsAccess(@NonNull Context context) throws GoogleAuthException, IOException {
        return zzl.requestGoogleAccountsAccess(context);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getAccountId(@NonNull Context ctx, @NonNull String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        return zzl.getAccountId(ctx, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getToken(@NonNull Context context, @NonNull Account account, @NonNull String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        return zzl.getToken(context, (Account)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static String getToken(@NonNull Context context, @NonNull String accountName, @NonNull String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        return zzl.getToken(context, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getToken(@NonNull Context context, @NonNull Account account, @NonNull String scope, @NonNull Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        return zzl.getToken(context, (Account)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static String getToken(@NonNull Context context, @NonNull String accountName, @NonNull String scope, @NonNull Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        return zzl.getToken(context, (String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull Account account, @NonNull String scope, @NonNull Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        Bundle bundle;
        if (extras == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzg(context2, (Account)var1_1, (String)var2_2, bundle).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull String accountName, @NonNull String scope, @NonNull Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var3_3;
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context2, account, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull Account account, @NonNull String scope, @NonNull Bundle extras, @NonNull Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        void var4_4;
        Bundle bundle;
        GoogleAuthUtil.zzf(callback);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putParcelable("callback_intent", (Parcelable)var4_4);
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzg(context2, (Account)var1_1, (String)var2_2, bundle).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull String accountName, @NonNull String scope, @NonNull Bundle extras, @NonNull Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var4_4;
        void var3_3;
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context2, account, (String)var2_2, (Bundle)var3_3, (Intent)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull Account account, @NonNull String scope, @NonNull Bundle extras, @NonNull String authority, @NonNull Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        void var4_4;
        Bundle bundle;
        Bundle bundle2;
        Preconditions.checkNotEmpty((String)authority, (Object)"Authority cannot be empty or null.");
        if (bundle2 == null) {
            bundle2 = new Bundle();
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        ContentResolver.validateSyncExtrasBundle((Bundle)bundle);
        bundle2.putString("authority", (String)var4_4);
        bundle2.putBundle("sync_extras", bundle);
        bundle2.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzg(context2, (Account)var1_1, (String)var2_2, bundle2).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static String getTokenWithNotification(@NonNull Context context, @NonNull String accountName, @NonNull String scope, @NonNull Bundle extras, @NonNull String authority, @NonNull Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context2, account, (String)var2_2, (Bundle)var3_3, (String)var4_4, (Bundle)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static List<AccountChangeEvent> getAccountChangeEvents(@NonNull Context context, int eventIndex, @NonNull String accountName) throws GoogleAuthException, IOException {
        void var2_2;
        void var1_1;
        return zzl.getAccountChangeEvents(context, (int)var1_1, (String)var2_2);
    }

    private GoogleAuthUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static void clearToken(@NonNull Context context, @NonNull String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        void var1_1;
        zzl.clearToken(context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(@NonNull Context context, @NonNull String token) {
        void var1_1;
        zzl.invalidateToken(context, (String)var1_1);
    }

    private static TokenData zzg(Context object, Account object2, String string, Bundle bundle) throws IOException, GoogleAuthException {
        try {
            object2 = zzl.zza(object, object2, string, bundle);
            GooglePlayServicesUtil.cancelAvailabilityErrorNotifications((Context)object);
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.cancelAvailabilityErrorNotifications((Context)object);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)userRecoverableAuthException);
            object = new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.", userRecoverableAuthException);
            throw object;
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            GooglePlayServicesUtil.showErrorNotification((int)googlePlayServicesAvailabilityException.getConnectionStatusCode(), (Context)object);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)googlePlayServicesAvailabilityException);
            object = new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.", googlePlayServicesAvailabilityException);
            throw object;
        }
        return object2;
    }
}

