/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzut;
import java.util.Collections;
import java.util.List;

public class Credential
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzGu;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzaie;
    private final List<IdToken> zzaif;
    @Nullable
    private final String zzaig;
    @Nullable
    private final String zzaih;
    @Nullable
    private final String zzaii;
    @Nullable
    private final String zzaij;
    @Nullable
    private final String zzaik;
    @Nullable
    private final String zzail;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.mVersionCode = n;
        String string9 = ((String)zzac.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzac.zzh((String)string9, (Object)"credential identifier cannot be empty");
        this.zzGu = string9;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.zzaie = uri;
        this.zzaif = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzaig = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzut.zzcs(string4);
        }
        this.zzaih = string4;
        this.zzaii = string5;
        this.zzaij = string6;
        this.zzaik = string7;
        this.zzail = string8;
        if (!TextUtils.isEmpty((CharSequence)this.zzaig) && !TextUtils.isEmpty((CharSequence)this.zzaih)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzGu;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzaie;
    }

    public List<IdToken> getIdTokens() {
        return this.zzaif;
    }

    @Nullable
    public String getPassword() {
        return this.zzaig;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzaii;
    }

    @Nullable
    public String getAccountType() {
        return this.zzaih;
    }

    public String zzqv() {
        return this.zzaij;
    }

    @Nullable
    public String getGivenName() {
        return this.zzaik;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzail;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzGu, (CharSequence)credential.zzGu) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzaa.equal((Object)this.zzaie, (Object)credential.zzaie) && TextUtils.equals((CharSequence)this.zzaig, (CharSequence)credential.zzaig) && TextUtils.equals((CharSequence)this.zzaih, (CharSequence)credential.zzaih) && TextUtils.equals((CharSequence)this.zzaii, (CharSequence)credential.zzaii);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzGu, this.mName, this.zzaie, this.zzaig, this.zzaih, this.zzaii});
    }

    public static class Builder {
        private final String zzGu;
        private String mName;
        private Uri zzaie;
        private List<IdToken> zzaif;
        private String zzaig;
        private String zzaih;
        private String zzaii;
        private String zzaij;
        private String zzaik;
        private String zzail;

        public Builder(String string) {
            this.zzGu = string;
        }

        public Builder(Credential credential) {
            this.zzGu = credential.zzGu;
            this.mName = credential.mName;
            this.zzaie = credential.zzaie;
            this.zzaif = credential.zzaif;
            this.zzaig = credential.zzaig;
            this.zzaih = credential.zzaih;
            this.zzaii = credential.zzaii;
            this.zzaij = credential.zzaij;
            this.zzaik = credential.zzaik;
            this.zzail = credential.zzail;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzaie = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzaig = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzaih = string;
            return this;
        }

        public Credential build() {
            return new Credential(4, this.zzGu, this.mName, this.zzaie, this.zzaif, this.zzaig, this.zzaih, this.zzaii, this.zzaij, this.zzaik, this.zzail);
        }
    }
}

