/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzuz;
import java.util.Collections;
import java.util.List;

public class Credential
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int zzaiI;
    private final String zzGV;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzajf;
    private final List<IdToken> zzajg;
    @Nullable
    private final String zzajh;
    @Nullable
    private final String zzaji;
    @Nullable
    private final String zzajj;
    @Nullable
    private final String zzajk;
    @Nullable
    private final String zzajl;
    @Nullable
    private final String zzajm;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.zzaiI = n;
        String string9 = ((String)zzac.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzac.zzh((String)string9, (Object)"credential identifier cannot be empty");
        this.zzGV = string9;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.zzajf = uri;
        this.zzajg = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzajh = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzuz.zzct(string4);
        }
        this.zzaji = string4;
        this.zzajj = string5;
        this.zzajk = string6;
        this.zzajl = string7;
        this.zzajm = string8;
        if (!TextUtils.isEmpty((CharSequence)this.zzajh) && !TextUtils.isEmpty((CharSequence)this.zzaji)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzGV;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzajf;
    }

    public List<IdToken> getIdTokens() {
        return this.zzajg;
    }

    @Nullable
    public String getPassword() {
        return this.zzajh;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzajj;
    }

    @Nullable
    public String getAccountType() {
        return this.zzaji;
    }

    public String zzqV() {
        return this.zzajk;
    }

    @Nullable
    public String getGivenName() {
        return this.zzajl;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzajm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzGV, (CharSequence)credential.zzGV) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzaa.equal((Object)this.zzajf, (Object)credential.zzajf) && TextUtils.equals((CharSequence)this.zzajh, (CharSequence)credential.zzajh) && TextUtils.equals((CharSequence)this.zzaji, (CharSequence)credential.zzaji) && TextUtils.equals((CharSequence)this.zzajj, (CharSequence)credential.zzajj);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzGV, this.mName, this.zzajf, this.zzajh, this.zzaji, this.zzajj});
    }

    public static class Builder {
        private final String zzGV;
        private String mName;
        private Uri zzajf;
        private List<IdToken> zzajg;
        private String zzajh;
        private String zzaji;
        private String zzajj;
        private String zzajk;
        private String zzajl;
        private String zzajm;

        public Builder(String string) {
            this.zzGV = string;
        }

        public Builder(Credential credential) {
            this.zzGV = credential.zzGV;
            this.mName = credential.mName;
            this.zzajf = credential.zzajf;
            this.zzajg = credential.zzajg;
            this.zzajh = credential.zzajh;
            this.zzaji = credential.zzaji;
            this.zzajj = credential.zzajj;
            this.zzajk = credential.zzajk;
            this.zzajl = credential.zzajl;
            this.zzajm = credential.zzajm;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzajf = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzajh = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzaji = string;
            return this;
        }

        public Credential build() {
            return new Credential(4, this.zzGV, this.mName, this.zzajf, this.zzajg, this.zzajh, this.zzaji, this.zzajj, this.zzajk, this.zzajl, this.zzajm);
        }
    }
}

