/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private zzn zzakI;
    private SignInConfiguration zzakJ;
    private boolean zzakK;
    private int zzakL;
    private Intent zzakM;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzakI = zzn.zzas((Context)this);
        Intent intent = this.getIntent();
        if (!"com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(intent.getAction())) {
            String string = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string.length() != 0 ? "Unknown action: ".concat(string) : new String("Unknown action: ")));
            this.finish();
        }
        this.zzakJ = (SignInConfiguration)intent.getParcelableExtra("config");
        if (this.zzakJ == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            this.zzj(new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN"));
        } else {
            this.zzakK = bundle.getBoolean("signingInGoogleApiClients");
            if (this.zzakK) {
                this.zzakL = bundle.getInt("signInResultCode");
                this.zzakM = (Intent)bundle.getParcelable("signInResultData");
                this.zzrA();
            }
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzakK);
        if (this.zzakK) {
            bundle.putInt("signInResultCode", this.zzakL);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzakM);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        this.setResult(0);
        switch (n) {
            case 40962: {
                this.zza(n2, intent);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private void zza(int n, Intent intent) {
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zzro() != null) {
                GoogleSignInAccount googleSignInAccount = signInAccount.zzro();
                this.zzakI.zzb(googleSignInAccount, this.zzakJ.zzrz());
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                this.zzakK = true;
                this.zzakL = n;
                this.zzakM = intent;
                this.zzrA();
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n2 = intent.getIntExtra("errorCode", 8);
                this.zzbq(n2);
                return;
            }
        }
        this.zzbq(8);
    }

    private void zzj(Intent intent) {
        intent.setPackage("com.google.android.gms");
        intent.putExtra("config", (Parcelable)this.zzakJ);
        try {
            this.startActivityForResult(intent, 40962);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            this.zzbq(8);
        }
    }

    private void zzrA() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza());
    }

    private void zzbq(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    private class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private zza() {
        }

        public Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzb((Context)SignInHubActivity.this, GoogleApiClient.zzvm());
        }

        public void zza(Loader<Void> loader, Void void_) {
            SignInHubActivity.this.setResult(SignInHubActivity.this.zzakL, SignInHubActivity.this.zzakM);
            SignInHubActivity.this.finish();
        }

        public void onLoaderReset(Loader<Void> loader) {
        }

        public /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            this.zza((Loader<Void>)loader, (Void)object);
        }
    }
}

