/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.SignInHubActivity;
import com.google.android.gms.auth.api.signin.internal.zzd;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzabk;
import com.google.android.gms.internal.zzacm;
import java.util.HashSet;

public final class zze {
    private static zzacm zzakx = new zzacm("GoogleSignInCommon", new String[0]);

    public static Intent zza(Context context, GoogleSignInOptions googleSignInOptions) {
        zzakx.zzb("GoogleSignInCommon", new Object[]{"getSignInIntent()"});
        SignInConfiguration signInConfiguration = new SignInConfiguration(context.getPackageName(), googleSignInOptions);
        Intent intent = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
        intent.setClass(context, SignInHubActivity.class);
        intent.putExtra("config", (Parcelable)signInConfiguration);
        return intent;
    }

    public static OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, Context context, GoogleSignInOptions googleSignInOptions) {
        zzn zzn2 = zzn.zzas((Context)context);
        GoogleSignInResult googleSignInResult = zze.zza(zzn2, googleSignInOptions);
        if (null != googleSignInResult) {
            zzakx.zzb("GoogleSignInCommon", new Object[]{"Eligible saved sign in result found"});
            return PendingResults.zzb((Result)googleSignInResult, (GoogleApiClient)googleApiClient);
        }
        return zze.zza(googleApiClient, zzn2, googleSignInOptions);
    }

    static GoogleSignInResult zza(zzn zzn2, GoogleSignInOptions googleSignInOptions) {
        HashSet hashSet;
        HashSet hashSet2;
        zzakx.zzb("GoogleSignInCommon", new Object[]{"getEligibleSavedSignInResult()"});
        zzac.zzw((Object)googleSignInOptions);
        GoogleSignInOptions googleSignInOptions2 = zzn2.zzrC();
        if (googleSignInOptions2 == null) {
            return null;
        }
        if (!zze.zza(googleSignInOptions2.getAccount(), googleSignInOptions.getAccount())) {
            return null;
        }
        if (googleSignInOptions.zzrk()) {
            return null;
        }
        if (googleSignInOptions.isIdTokenRequested()) {
            if (!googleSignInOptions2.isIdTokenRequested()) {
                return null;
            }
            if (!googleSignInOptions.getServerClientId().equals(googleSignInOptions2.getServerClientId())) {
                return null;
            }
        }
        if (!(hashSet2 = new HashSet(googleSignInOptions2.zzrj())).containsAll(hashSet = new HashSet(googleSignInOptions.zzrj()))) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = zzn2.zzrB();
        if (googleSignInAccount != null && !googleSignInAccount.zza()) {
            return new GoogleSignInResult(googleSignInAccount, Status.zzazx);
        }
        return null;
    }

    private static boolean zza(Account account, Account account2) {
        if (account == null) {
            return account2 == null;
        }
        return account.equals((Object)account2);
    }

    private static OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, final zzn zzn2, final GoogleSignInOptions googleSignInOptions) {
        zzakx.zzb("GoogleSignInCommon", new Object[]{"trySilentSignIn()"});
        zzaad.zza zza2 = googleApiClient.zza((zzaad.zza)new zza<GoogleSignInResult>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzk)zzd2.zzxD()).zza(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zza(GoogleSignInAccount googleSignInAccount, Status status) throws RemoteException {
                        if (googleSignInAccount != null) {
                            zzn2.zzb(googleSignInAccount, googleSignInOptions);
                        }
                        this.zzb(new GoogleSignInResult(googleSignInAccount, status));
                    }
                }, googleSignInOptions);
            }

            protected GoogleSignInResult zzn(Status status) {
                return new GoogleSignInResult(null, status);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzn(status);
            }
        });
        return new zzabk((PendingResult)zza2);
    }

    public static PendingResult<Status> zza(GoogleApiClient googleApiClient, Context context) {
        zzakx.zzb("GoogleSignInCommon", new Object[]{"Signing out"});
        zze.zzar(context);
        return googleApiClient.zzb((zzaad.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzk)zzd2.zzxD()).zzb(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzl(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzrt());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static PendingResult<Status> zzb(GoogleApiClient googleApiClient, Context context) {
        zzakx.zzb("GoogleSignInCommon", new Object[]{"Revoking access"});
        zze.zzar(context);
        return googleApiClient.zzb((zzaad.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzk)zzd2.zzxD()).zzc(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzm(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzrt());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    private static void zzar(Context context) {
        zzn zzn2 = zzn.zzas((Context)context);
        zzn2.zzrD();
        for (GoogleApiClient googleApiClient : GoogleApiClient.zzvm()) {
            googleApiClient.zzvn();
        }
        zzaax.zzwx();
    }

    public static GoogleSignInResult getSignInResultFromIntent(Intent intent) {
        if (intent == null || !intent.hasExtra("googleSignInStatus") && !intent.hasExtra("googleSignInAccount")) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)intent.getParcelableExtra("googleSignInAccount");
        Status status = (Status)intent.getParcelableExtra("googleSignInStatus");
        if (googleSignInAccount != null) {
            status = Status.zzazx;
        }
        return new GoogleSignInResult(googleSignInAccount, status);
    }

    private static abstract class zza<R extends Result>
    extends zzaad.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Auth.GOOGLE_SIGN_IN_API, googleApiClient);
        }

        public /* synthetic */ void setResult(Object object) {
            super.zzb((Result)object);
        }
    }
}

