/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzard;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private int zzaku;
    private final String zzIk;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzakR;
    private final List<IdToken> zzakS;
    @Nullable
    private final String zzakT;
    @Nullable
    private final String zzakU;
    @Nullable
    private final String zzakV;
    @Nullable
    private final String zzakW;
    @Nullable
    private final String zzakX;
    @Nullable
    private final String zzakY;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.zzaku = n;
        String string9 = ((String)zzbo.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzbo.zzh((String)string9, (Object)"credential identifier cannot be empty");
        this.zzIk = string9;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.zzakR = uri;
        this.zzakS = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzakT = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzard.zzbN(string4);
        }
        this.zzakU = string4;
        this.zzakV = string5;
        this.zzakW = string6;
        this.zzakX = string7;
        this.zzakY = string8;
        if (!TextUtils.isEmpty((CharSequence)this.zzakT) && !TextUtils.isEmpty((CharSequence)this.zzakU)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzIk;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzakR;
    }

    public List<IdToken> getIdTokens() {
        return this.zzakS;
    }

    @Nullable
    public String getPassword() {
        return this.zzakT;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzakV;
    }

    @Nullable
    public String getAccountType() {
        return this.zzakU;
    }

    @Nullable
    public String getGivenName() {
        return this.zzakX;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzakY;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)credential.zzaku);
        zzd.zza((Parcel)parcel2, (int)8, (String)credential.zzakW, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzIk, (CharSequence)credential.zzIk) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzbe.equal((Object)this.zzakR, (Object)credential.zzakR) && TextUtils.equals((CharSequence)this.zzakT, (CharSequence)credential.zzakT) && TextUtils.equals((CharSequence)this.zzakU, (CharSequence)credential.zzakU) && TextUtils.equals((CharSequence)this.zzakV, (CharSequence)credential.zzakV);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzIk, this.mName, this.zzakR, this.zzakT, this.zzakU, this.zzakV});
    }

    public static class Builder {
        private final String zzIk;
        private String mName;
        private Uri zzakR;
        private List<IdToken> zzakS;
        private String zzakT;
        private String zzakU;
        private String zzakV;
        private String zzakW;
        private String zzakX;
        private String zzakY;

        public Builder(String string) {
            this.zzIk = string;
        }

        public Builder(Credential credential) {
            this.zzIk = credential.zzIk;
            this.mName = credential.mName;
            this.zzakR = credential.zzakR;
            this.zzakS = credential.zzakS;
            this.zzakT = credential.zzakT;
            this.zzakU = credential.zzakU;
            this.zzakV = credential.zzakV;
            this.zzakW = credential.zzakW;
            this.zzakX = credential.zzakX;
            this.zzakY = credential.zzakY;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzakR = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzakT = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzakU = string;
            return this;
        }

        public Credential build() {
            return new Credential(4, this.zzIk, this.mName, this.zzakR, this.zzakS, this.zzakT, this.zzakU, this.zzakV, this.zzakW, this.zzakX, this.zzakY);
        }
    }
}

